package ru.yandex.autotests.direct.data;

import ru.yandex.autotests.direct.objects.advqstrings.Word;

/**
 * User: xy6er
 * Date: 07.06.13
 * Time: 21:22
 */

/**
 * Константы для работы с AdvQ.
 */
public abstract class AdvqConstants {

    /**
     * Случайное слово, для проверки подключения к базе
     */
    public static final Word TEST_WORD = new Word("forex");

    /**
     * Предел кол-во подряд полученных 'tainted=true'.
     * Если достигли этого предела, то прекращаем тест.
     */
    public static final int MAX_TAINTED_COUNT = 3;

    /**
     * Предел количество неудачных подключений к базе
     */
    public static final int MAX_ATTEMPTS_CONNECTION = 3;

    /**
     * Максимальное допустимое отклонение по показам
     */
    public static final double MAX_TOTAL_COUNT_DIFF = 50;

    /**
     * Нижняя граница для отклонения по количеству недель/месяцев
     * Означает, что на продакшене не должно быть больше недель/месяцев, чем на бете
     */
    public static final int MIN_COUNT_DIFF = 0;

    /**
     * Верхняя граница для отклонения по количеству недель/месяцев
     * Означает, что на бете не должно быть больше 2-ух недель/месяцев, чем на продакшене
     */
    public static final int MAX_COUNT_DIFF = 2;

    /**
     *
     *
     */
    public static final double MAX_INCLUDING_PHRASES_DIFF = 5;
}
