package ru.yandex.autotests.direct.data;

/**
 * User: xy6er
 * Date: 17.06.13
 * Time: 15:02
 */

/**
 * Константы для отчета
 */
public class ReportConstants {
    /**
     * Формат наименований параметризованных тестов.
     */
    public static final String TEST_NAME_FORMAT = "{index}: Word = {0}";

    /**
     * Папка кастомного отчета
     * Взяза из ${report.directory} в pom.xml
     */
    public static final String REPORT_DIR_PATH = "target/site/custom-report-plugin";

    /**
     * Заголовки таблиц отчета
     */
    public static final String WORDS_TEST_TITLE = "Расхождение в разделе 'По фразам'";
    public static final String WEEKS_COUNT_TITLE = "Количество недель";
    public static final String WEEKS_DIFFERENCE_TITLE = "Расхождение по неделям";
    public static final String WEEKS_VALUE_TITLE = "Значения по неделям";
    public static final String MONTH_COUNT_TITLE = "Количество месяцев";
    public static final String MONTH_DIFFERENCE_TITLE = "Расхождение по месяцам";
    public static final String MONTH_VALUE_TITLE = "Значения по месяцам";
    public static final String WORD_TITLE_FORMAT = "%s для фразы '%s'";
    public static final String INCLUDING_PHRASES_TITLE = "Расхождение по тексту суперфраз";
    public static final String INCLUDING_PHRASES_DIFFERENCE_TITLE = "Расхождение по суперфразам";

    /**
     * Название первого столбца таблицы отчета
     */
    public static final String WORD_HEADER = "Фраза";
    public static final String WEEK_HEADER = "Неделя";
    public static final String COMPARE_WEEKS_HEADER = "Сравниваемые недели";
    public static final String MONTH_HEADER = "Месяц";
    public static final String COMPARE_MONTH_HEADER = "Сравниваемые месяцы";

    /**
     * Статусы тестов, для таблицы отчета
     */
    public static final String OK = "ok";
    public static final String FAIL = "fail";

}
