package ru.yandex.autotests.direct.objects;

import java.util.List;

/**
 * User: xy6er
 * Date: 09.06.13
 * Time: 11:47
 */

public class WeeklyHist {
    public List<Request> requests;

    public static class Request extends RequestBase {
        public List<Hist> hist;

        public static class Hist extends HistBase {
            public String monday;
        }
    }

    private Request getRequests() {
        return requests.get(0);
    }

    public int getTotalCount() {
        return getRequests().current.total_count;
    }

    public boolean isTainted() {
        return getRequests().tainted;
    }

    public int getWeeksCount() {
        return getRequests().hist.size();
    }

    public Request.Hist findHist(String monday) {
        for (Request.Hist hist : getRequests().hist) {
            if (hist.monday.equals(monday)) {
                return hist;
            }
        }
        return null;
    }

    public List<Request.Hist> getHists() {
        return getRequests().hist;
    }

}
