package ru.yandex.autotests.direct.objects;

import java.util.List;

/**
 * User: xy6er
 * Date: 09.06.13
 * Time: 2:41
 */

public class WordStat {
    public List<Request> requests;

    public static class Request {
        public String lang;
        public String req;
        public String dbname;
        public Stat stat;

        public static class Stat {
            public Association[] associations;
            public String count_by_regions;
            public String db_date_str;
            public Db_info db_info;
            public double db_timestamp;
            public String error; //TODO-b delete
            public String[] errors;
            public boolean has_next_page;
            public IncludingPhrase[] including_phrases;
            public double overall_time;
            public double precision;
            public Object rpn;
            public double search_time;
            public boolean tainted;
            public int total_count;
            public boolean valid_query;
            public int page_count;

            public static class Db_info {
                public String phits;
                public String quhits;
                public String sumhits;
            }

            public static class Association {
                public int cnt;
                public String phrase;
                public String regs;
            }

            public static class IncludingPhrase {
                public int cnt;
                public String filters;
                public String phrase;
                public String phrase_guid;
            }

        }
    }

    public int getTotalCount() {
        return requests.get(0).stat.total_count;
    }

    public boolean isTainted() {
        return requests.get(0).stat.tainted;
    }

    public Request.Stat.IncludingPhrase[] getIncludingPhrases() {
        return requests.get(0).stat.including_phrases;
    }
}

