package ru.yandex.autotests.direct.objects.report;

import javax.xml.bind.annotation.*;
import java.util.ArrayList;
import java.util.List;

import static ru.yandex.autotests.direct.data.ReportConstants.OK;

/**
 * User: xy6er
 * Date: 20.09.13
 * Time: 9:59
 */

@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "", propOrder = {
        "reportTables",
        "errorMessages"
})
public class Report {
    @XmlElement(required = true)
    protected List<ReportTable> reportTables;
    @XmlElement(required = true)
    protected List<String> errorMessages;
    @XmlAttribute
    protected String title;
    @XmlAttribute
    protected String status;
    @XmlAttribute(name = "advq.prod")
    protected String advqProd;
    @XmlAttribute(name = "advq.beta")
    protected String advqBeta;

    public List<ReportTable> getReportTables() {
        if (reportTables == null) {
            reportTables = new ArrayList<>();
        }
        return reportTables;
    }

    public List<String> getErrorMessages() {
        if (errorMessages == null) {
            errorMessages = new ArrayList<>();
        }
        return this.errorMessages;
    }

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getStatus() {
        if (status == null) {
            setStatus(OK);
        }
        return status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getAdvqProd() {
        return advqProd;
    }

    public void setAdvqProd(String advqProd) {
        this.advqProd = advqProd;
    }

    public String getAdvqBeta() {
        return advqBeta;
    }

    public void setAdvqBeta(String advqBeta) {
        this.advqBeta = advqBeta;
    }
}
