package ru.yandex.autotests.direct.objects.report;

import javax.xml.bind.annotation.*;
import java.util.ArrayList;
import java.util.List;

import static ru.yandex.autotests.direct.data.ReportConstants.OK;

/**
 * User: xy6er
 * Date: 20.09.13
 * Time: 10:04
 */

@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "ReportTable", propOrder = {
        "reportRows"
})
public class ReportTable {
    @XmlElement(required = true)
    protected List<ReportRow> reportRows;
    @XmlAttribute
    protected String title;
    @XmlAttribute
    protected String header;
    @XmlAttribute
    protected String status;
    @XmlAttribute
    protected String prodColumnName;
    @XmlAttribute
    protected String betaColumnName;
    @XmlAttribute
    protected String diffColumnName;

    public List<ReportRow> getReportRows() {
        if (reportRows == null) {
            reportRows = new ArrayList<>();
        }
        return reportRows;
    }

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getHeader() {
        return header;
    }

    public void setHeader(String header) {
        this.header = header;
    }

    public String getStatus() {
        if (status == null) {
            setStatus(OK);
        }
        return status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getProdColumnName() {
        return prodColumnName;
    }

    public void setProdColumnName(String prodColumnName) {
        this.prodColumnName = prodColumnName;
    }

    public String getBetaColumnName() {
        return betaColumnName;
    }

    public void setBetaColumnName(String betaColumnName) {
        this.betaColumnName = betaColumnName;
    }

    public String getDiffColumnName() {
        return diffColumnName;
    }

    public void setDiffColumnName(String diffColumnName) {
        this.diffColumnName = diffColumnName;
    }
}
