package ru.yandex.autotests.direct.utils;

import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

/**
 * @author Roman Kuhta (kuhtich@yandex-team.ru)
 */
public abstract class TestConfiguration implements TestRule {
    private Statement statement(final Statement base) {
        return new Statement() {
            @Override
            public void evaluate() throws Throwable {
                try {
                    before();
                    base.evaluate();
                } finally {
                    after();
                }
            }
        };
    }

    /**
     * Override to tear down your specific external resource.
     */
    protected void after() {
        // do nothing
    }

    public Statement apply(Statement base, Description description) {
        return statement(base);
    }

    /**
     * Override to set up your specific external resource.
     *
     * @throws if setup fails (which will disable {@code after}
     */
    protected void before() {
        // do nothing
    }
}