<!--
    Схема для генерации отчета;
    Для генерации отчета используются все xml файлы находящиеся в той же папки где этот файл;
    Xml-ки генерируются каждым тестКлассом
    Статические файлы(css, js, image) репорта лежат в reportfiles/
    Report и ReportTables группируются по @title
-->
<xsl:stylesheet version="2.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
    <xsl:output method="html" indent="yes" encoding="utf-8" doctype-public=""/>

    <xsl:param name="source-file-names"/>
    <xsl:variable name="source-files" select="document(tokenize($source-file-names,'\|'))"/>
    <xsl:variable name='ok' select="'ok'"/>
    <xsl:variable name='fail' select="'fail'"/>

    <xsl:template match="/">
        <html>
            <head>
                <title>AdvQ Words Test Report</title>
                <link rel="stylesheet" type="text/css" href="reportfiles/style.css"/>
                <link rel="stylesheet" type="text/css" href="reportfiles/bootstrap.css" />

                <script type="text/javascript" src="reportfiles/js/jquery-latest.js"/>
                <script type="text/javascript" src="reportfiles/js/tablesorter.js"/>
                <script type="text/javascript" src="reportfiles/js/bootstrap.min.js"/>
                <script type="text/javascript" src="reportfiles/js/isles.js"/>

                <script type="text/javascript">
                    $(document).ready(function() {
                    var tableList = document.getElementsByClassName('tablesorter');
                    $(tableList).tablesorter({sortList:[[3,1]], widgets: ['zebra']});
                    }
                    );
                </script>
            </head>

            <body>
                <div class="tab-content">
                    <div class="testParams">advq.prod = <xsl:value-of select="$source-files[1]/report[1]/@advq.prod" /></div>
                    <div class="testParams">advq.beta = <xsl:value-of select="$source-files[1]/report[1]/@advq.beta" /></div>
                 </div>
                <xsl:for-each-group select="$source-files/report" group-by="@title">
                    <xsl:apply-templates select="current-group()[1]"/>
                </xsl:for-each-group>
            </body>
        </html>
    </xsl:template>

    <xsl:template name="toggle-arrows">
        <span class="toggle-arrow up">▶</span>
        <span class="toggle-arrow down">▼</span>
    </xsl:template>

    <xsl:template match="report">
        <div class="tab-content">
            <div class="tab-pane active">
                <div class="dimension round-border">
                    <xsl:variable name="reportTitle" select="@title"/>
                    <xsl:variable name="status">
                        <xsl:choose>
                            <xsl:when test="count($source-files/report[@title = $reportTitle and @status = $fail])">
                                <xsl:value-of select="$fail"/>
                            </xsl:when>
                            <xsl:otherwise>
                                <xsl:value-of select="$ok"/>
                            </xsl:otherwise>
                        </xsl:choose>
                    </xsl:variable>

                    <xsl:attribute name="class">
                        <xsl:text>dimension round-border </xsl:text>
                        <xsl:value-of select="$status"/>
                        <xsl:text> collapsed</xsl:text>
                    </xsl:attribute>

                    <h2 class="title">
                        <xsl:value-of select="@title"/>
                        <xsl:call-template name="toggle-arrows"/>
                        <xsl:apply-templates select="$source-files/report[@title = $reportTitle]/errorMessages"/>
                        <span class="status"><xsl:value-of select="$status"/></span>
                    </h2>
                    <div class="steps">
                        <xsl:for-each-group select="$source-files/report[@title = $reportTitle]/reportTables" group-by="@title">
                            <xsl:apply-templates select="current-group()[1]"/>
                        </xsl:for-each-group>
                    </div>
                </div>
            </div>
        </div>
    </xsl:template>

    <xsl:template match="errorMessages">
        <span class="errorMessage"><xsl:value-of select="."/>;</span>
    </xsl:template>

    <xsl:template match="reportTables">
        <div class="step">
            <xsl:variable name="reportTableTitle" select="@title"/>
            <xsl:variable name="status">
                <xsl:choose>
                    <xsl:when test="count($source-files/report/reportTables[@title = $reportTableTitle and @status = $fail])">
                        <xsl:value-of select="$fail"/>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:value-of select="$ok"/>
                    </xsl:otherwise>
                </xsl:choose>
            </xsl:variable>

            <xsl:attribute name="class">
                <xsl:text>step </xsl:text>
                <xsl:value-of select="$status"/>
                <xsl:text> collapsed</xsl:text>
            </xsl:attribute>

            <div class="title round-border">
                <xsl:call-template name="toggle-arrows"/>
                <span class="msg"><xsl:value-of select="@title"/></span>
                <span class="status"><xsl:value-of select="$status"/></span>
            </div>
            <div class="content">
                <xsl:variable name="reportRowsCount" select="count(reportRows)"/>
                <xsl:if test="$reportRowsCount > 0">
                    <table class="tablesorter" cellspacing="1" cellpadding="0" border="0">
                        <thead>
                            <tr>
                                <th class="header1"><xsl:value-of select="@header"/></th>
                                <th><xsl:apply-templates select="@prodColumnName" /></th>
                                <th><xsl:apply-templates select="@betaColumnName" /></th>
                                <th><xsl:apply-templates select="@diffColumnName" /></th>
                            </tr>
                        </thead>
                        <tbody>
                            <xsl:apply-templates select="$source-files/report/reportTables[@title = $reportTableTitle]/reportRows"/>
                        </tbody>
                    </table>
                </xsl:if>
            </div>
        </div>
    </xsl:template>

    <xsl:decimal-format name="spaceSeparator" decimal-separator="," grouping-separator="&#xa0;" />
    <xsl:template match="reportRows">
        <tr>
            <td>
                <xsl:value-of select="@name"/>
            </td>
            <td>
                <xsl:value-of select="format-number(@prodValue, '#&#xa0;###&#xa0;###', 'spaceSeparator')"/>
            </td>
            <td>
                <xsl:value-of select="format-number(@betaValue, '#&#xa0;###&#xa0;###', 'spaceSeparator')"/>
            </td>
            <td>
                <xsl:value-of select="@diff"/>
            </td>
        </tr>
    </xsl:template>
</xsl:stylesheet>