package ru.yandex.autotests.direct.api.adextensions;

import java.util.Arrays;
import java.util.Collection;
import ru.yandex.qatools.allure.annotations.TestCaseId;

import com.yandex.direct.api.v5.adextensions.AdExtensionFieldEnum;
import com.yandex.direct.api.v5.adextensions.GetResponse;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.directapi.ApiFeatures;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.api5.adextensions.AdExtensionsSelectionCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.adextensions.GetRequestMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.IdsCriteriaMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

/**
 * Created by hmepas on 13.03.17
 */
@Aqua.Test
@Features(ApiFeatures.NOT_REGRESSION_YET)
@Description("Чистим AdExtensions на пользователе")
@RunWith(Parameterized.class)
public class ClearUser {

    @ClassRule
    public static ApiSteps api = new ApiSteps();

    @Rule
    public Trashman trashman = new Trashman(api);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Parameterized.Parameter()
    public String login;

    @Parameterized.Parameters(name = "id = {0}")
    public static Collection testData() {
        Object[][] data = new Object[][]{
                { "ads-client" }
        };

        return Arrays.asList(data);
    }

    @Test
    @TestCaseId("2748")
    public void deleteUserAdExtensions() {
        GetResponse getResponse = api.as(login).userSteps.adExtensionsSteps().getAdExtensions(
                new GetRequestMap()
                        .withFieldNames(AdExtensionFieldEnum.ID)
                        .withSelectionCriteria(new AdExtensionsSelectionCriteriaMap())
        );

        api.userSteps.adExtensionsSteps().shouldGetResultOnDelete(
                new IdsCriteriaMap().withIds(
                    getResponse.getAdExtensions().stream().map(a -> a.getId()).toArray(Long[]::new)
                ),
                getResponse.getAdExtensions().stream().map(a -> ExpectedResult.success(a.getId())).toArray(ExpectedResult[]::new)
        );
    }
}
