package ru.yandex.autotests.direct.api.adextensions.add;

import org.apache.commons.lang.RandomStringUtils;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.adextensions.AdExtensionsFeatures;
import ru.yandex.autotests.direct.api.adextensions.AdExtensionsLogins;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.Logins;
import ru.yandex.autotests.directapi.model.api5.adextensions.AdExtensionAddItemMap;
import ru.yandex.autotests.directapi.model.api5.adextensions.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.adextensiontypes.CalloutMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;
import ru.yandex.qatools.allure.annotations.TestCaseId;

import java.util.Arrays;
import java.util.Collection;

/**
 * Created by proxeter on 17.02.16.
 * <p>
 * https://st.yandex-team.ru/TESTIRT-8603
 */
@Aqua.Test
@Description("Проверка агентств и субклиентов. Позитивные сценарии")
@Issue("https://st.yandex-team.ru/DIRECT-50734")
@Features(AdExtensionsFeatures.ADD)
@RunWith(Parameterized.class)
public class AddAdExtensionAgenciesAndSubclientsTest {

    @ClassRule
    public static ApiSteps api = new ApiSteps();

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Parameterized.Parameter(0)
    public String description;

    @Parameterized.Parameter(1)
    public String operator;

    @Parameterized.Parameter(2)
    public String client;

    @Parameterized.Parameter(3)
    public ExpectedResult expectedResult;

    @Parameterized.Parameters(name = "{0}")
    public static Collection testData() {
        Object[][] data = new Object[][]{
                {"агентство - субклиент с правами редактирования",
                        AdExtensionsLogins.AGENCY_CAMPAIGNS, AdExtensionsLogins.SUB_CLIENT_WITH_EDIT_RIGHTS, ExpectedResult.success()},
                {"агентство - субклиент без прав редактирования",
                        AdExtensionsLogins.AGENCY_CAMPAIGNS, AdExtensionsLogins.SUB_CLIENT_WITHOUT_EDIT_RIGHTS, ExpectedResult.success()},
                {"представитель агентства - субклиент",
                        AdExtensionsLogins.AGENCY_REP_CAMPAIGNS, AdExtensionsLogins.SUBCLIENT_CAMPAIGNS, ExpectedResult.success()},
                {"сервисируемый клиент",
                        AdExtensionsLogins.SERV_CLIENT, null, ExpectedResult.success()},
                {"субклиент с правами редактирования",
                        Logins.SUB_CLIENT_WITH_EDIT_RIGHTS, null, ExpectedResult.success()},
//                Не поддерживается новым ppcRbac, DIRECT-82413
//                {"субклиент с двумя агентствами, но с правами редактирования только от одного",
//                        AdExtensionsLogins.SUBCLIENT_WITH_TWO_AG, null, ExpectedResult.success()},
//                Не поддерживается новым ppcRbac, DIRECT-82413
//                {"агентство - субклиент с двумя агентствами",
//                        AdExtensionsLogins.AGENCY_1_CAMPAIGNS, AdExtensionsLogins.SUBCLIENT_CAMPAIGNS, ExpectedResult.success()},

        };
        return Arrays.asList(data);
    }

    @Before
    public void before() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(operator);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("1224")
    public void checkRightsToAddAdExtension() {
        api.as(Logins.SUPER_LOGIN, operator).userSteps.adExtensionsSteps()
                .shouldGetResultOnAdExtensionsAdd(new AddRequestMap()
                                .withAdExtensions(new AdExtensionAddItemMap()
                                        .withCallout(new CalloutMap()
                                                .withCalloutText(RandomStringUtils.randomAlphabetic(8)))),
                        client,
                        expectedResult
                );
    }
}
