package ru.yandex.autotests.direct.api.adextensions.add;


import com.yandex.direct.api.v5.adextensions.AddResponse;
import org.apache.commons.lang.RandomStringUtils;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.AdditionsItemCalloutsStatusmoderate;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.AdditionsItemCalloutsRecord;
import ru.yandex.autotests.direct.db.steps.DirectJooqDbSteps;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.direct.api.adextensions.AdExtensionsFeatures;
import ru.yandex.autotests.direct.api.adextensions.AdExtensionsLogins;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.api5.adextensions.AdExtensionAddItemMap;
import ru.yandex.autotests.directapi.model.api5.adextensions.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.adextensiontypes.CalloutMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.irt.testutils.beandiffer2.comparestrategy.defaultcomparestrategy.DefaultCompareStrategies;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.hasSize;
import static org.hamcrest.Matchers.notNullValue;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;
import static ru.yandex.autotests.direct.db.utils.JooqRecordDifferMatcher.recordDiffer;

/**
 * Created by proxeter on 21.03.16.
 * https://st.yandex-team.ru/TESTIRT-8603
 */
@Aqua.Test
@Description("Проверка сохранения в базе текстовых дополнений")
@Issue("https://st.yandex-team.ru/DIRECT-50696")
@Features(AdExtensionsFeatures.ADD)
@Tag(TagDictionary.TRUNK)
public class AddAdExtensionDatabaseTest {

    private static final String LOGIN = AdExtensionsLogins.AD_EXTENSIONS_CLIENT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);
    private static DirectJooqDbSteps jooqDbSteps;

    @Rule
    public Trashman trashman = new Trashman(api);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    private String clientId;

    @Before
    public void before() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);
        jooqDbSteps = api.userSteps.getDirectJooqDbSteps().useShardForLogin(LOGIN);

        clientId = api.userSteps.clientFakeSteps().getClientData(LOGIN).getClientID();
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("1226")
    public void addAdExtensionCheckDb() {
        String calloutText = RandomStringUtils.random(6, true, false);

        AddResponse addResponse = api.userSteps.adExtensionsSteps().adExtensionsAdd(
                new AddRequestMap().withAdExtensions(
                        new AdExtensionAddItemMap()
                                .withCallout(
                                        new CalloutMap().withCalloutText(calloutText)
                                )
                )
        );
        assumeThat("текстовое дополнение добавлено", addResponse.getAddResults(), hasSize(1));

        Long id = addResponse.getAddResults().get(0).getId();
        AdditionsItemCalloutsRecord additionsItemCallouts = jooqDbSteps.bannerAdditionsSteps().getCallout(id);

        AdditionsItemCalloutsRecord expectedItemCallout = new AdditionsItemCalloutsRecord();
        expectedItemCallout.setAdditionsItemId(id);
        expectedItemCallout.setCalloutText(calloutText);
        expectedItemCallout.setStatusmoderate(AdditionsItemCalloutsStatusmoderate.Ready);
        expectedItemCallout.setClientid(Long.valueOf(clientId));
        expectedItemCallout.setIsDeleted(0);

        assertThat(
                "текстовое дополнение было записано в базу",
                additionsItemCallouts,
                recordDiffer(expectedItemCallout).useCompareStrategy(DefaultCompareStrategies.onlyExpectedFields())
        );
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("1227")
    public void addTwoAdExtensionsCheckDb() {
        String calloutText1 = RandomStringUtils.random(6, true, false);
        String calloutText2 = RandomStringUtils.random(6, true, false);

        AddResponse addResponse = api.userSteps.adExtensionsSteps().shouldGetResultOnAdExtensionsAdd(
                new AddRequestMap().withAdExtensions(
                        new AdExtensionAddItemMap()
                                .withCallout(
                                        new CalloutMap().withCalloutText(calloutText1)
                                ),
                        new AdExtensionAddItemMap()
                                .withCallout(
                                        new CalloutMap().withCalloutText(calloutText2)
                                )
                ),
                ExpectedResult.success(),
                ExpectedResult.success()
        );

        Long id1 = addResponse.getAddResults().get(0).getId();
        AdditionsItemCalloutsRecord calloutItem1 = jooqDbSteps.bannerAdditionsSteps().getCallout(id1);
        assumeThat("текстовое дополнение найдено в БД", calloutItem1, notNullValue());

        Long id2 = addResponse.getAddResults().get(1).getId();
        AdditionsItemCalloutsRecord calloutItem2 = jooqDbSteps.bannerAdditionsSteps().getCallout(id2);
        assumeThat("текстовое дополнение найдено в БД", calloutItem2, notNullValue());

        AdditionsItemCalloutsRecord expectedItemCallout1 = new AdditionsItemCalloutsRecord();
        expectedItemCallout1.setAdditionsItemId(id1);
        expectedItemCallout1.setCalloutText(calloutText1);
        expectedItemCallout1.setStatusmoderate(AdditionsItemCalloutsStatusmoderate.Ready);
        expectedItemCallout1.setClientid(Long.valueOf(clientId));
        expectedItemCallout1.setIsDeleted(0);

        AdditionsItemCalloutsRecord expectedItemCallout2 = new AdditionsItemCalloutsRecord();
        expectedItemCallout2.setAdditionsItemId(id2);
        expectedItemCallout2.setCalloutText(calloutText2);
        expectedItemCallout2.setStatusmoderate(AdditionsItemCalloutsStatusmoderate.Ready);
        expectedItemCallout2.setClientid(Long.valueOf(clientId));
        expectedItemCallout2.setIsDeleted(0);

        assumeThat(
                "текстовoe дополнение добавлено expectedItemCallout1 в бд",
                calloutItem1, recordDiffer(expectedItemCallout1)
                        .useCompareStrategy(DefaultCompareStrategies.onlyExpectedFields())
        );
        assertThat(
                "текстовое дополнение добавлено expectedItemCallout2 в бд",
                calloutItem2, recordDiffer(expectedItemCallout2)
                        .useCompareStrategy(DefaultCompareStrategies.onlyExpectedFields())
        );

    }
}
