package ru.yandex.autotests.direct.api.adextensions.add;

import org.apache.commons.lang.RandomStringUtils;
import org.json.simple.JSONObject;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.adextensions.AdExtensionsFeatures;
import ru.yandex.autotests.direct.api.adextensions.AdExtensionsLogins;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5Error;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.apiclient.errors.Path;
import ru.yandex.autotests.directapi.model.api5.adextensions.AdExtensionAddItemMap;
import ru.yandex.autotests.directapi.model.api5.adextensions.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.adextensiontypes.CalloutMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.equalTo;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

/**
 * Created by proxeter on 25.02.16.
 * <p>
 * https://st.yandex-team.ru/TESTIRT-8603
 */
@Aqua.Test
@Description("Проверка списания баллов при добавлении текстового дополнения")
@Issue("https://st.yandex-team.ru/DIRECT-50696")
@Features(AdExtensionsFeatures.ADD)
public class AddAdExtensionUnitsTest {

    private static final String LOGIN = AdExtensionsLogins.UNITS_ADD_LOGIN;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);

    @Rule
    public Trashman trashman = new Trashman(api);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Before
    public void before() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("1230")
    public void addAdExtensionUnits() {
        int unitsBefore = api.userSteps.clientFakeSteps().fakeClientUnitsBalance(LOGIN);
        api.userSteps.adExtensionsSteps().shouldGetResultOnAdExtensionsAdd(
                new AddRequestMap().withAdExtensions(
                        new AdExtensionAddItemMap()
                                .withCallout(
                                        new CalloutMap().withCalloutText(RandomStringUtils.randomAlphabetic(8))
                                )
                ),
                ExpectedResult.success()
        );
        int unitsAfter = api.userSteps.clientFakeSteps().fakeClientUnitsBalance(LOGIN);

        Integer cost = AddRequestMap.ADD_UNITS_COST + (1 * AddRequestMap.ADD_OBJECT_COST); // 1 объект
        assertThat("списалось правильное количество баллов", unitsAfter, equalTo(unitsBefore - cost));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("1231")
    public void addTwoAdExtensionUnits() {
        int unitsBefore = api.userSteps.clientFakeSteps().fakeClientUnitsBalance(LOGIN);
        api.userSteps.adExtensionsSteps().adExtensionsAdd(
                new AddRequestMap().withAdExtensions(
                        new AdExtensionAddItemMap()
                                .withCallout(
                                        new CalloutMap().withCalloutText(RandomStringUtils.randomAlphabetic(8))
                                ),
                        new AdExtensionAddItemMap()
                                .withCallout(
                                        new CalloutMap().withCalloutText(RandomStringUtils.randomAlphabetic(8))
                                )
                )
        );
        int unitsAfter = api.userSteps.clientFakeSteps().fakeClientUnitsBalance(LOGIN);

        Integer cost = AddRequestMap.ADD_UNITS_COST + (2 * AddRequestMap.ADD_OBJECT_COST); // 2 cost
        assertThat("списалось правильное количество баллов", unitsAfter, equalTo(unitsBefore - cost));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("2154")
    public void addAdExtensionWithErrorUnits() {
        int unitsBefore = api.userSteps.clientFakeSteps().fakeClientUnitsBalance(LOGIN);
        api.userSteps.adExtensionsSteps().shouldGetResultOnAdExtensionsAdd(
                new AddRequestMap().withAdExtensions(
                        new AdExtensionAddItemMap()
                                .withCallout(
                                        new CalloutMap().withCalloutText("!@#$%^&*():,.;")
                                )
                ),
                ExpectedResult.errors(new Notification(5002, Api5ErrorDetails.CALLOUT_TEXT_CONTAINS_INVALID_CHARACTERS))
        );
        int unitsAfter = api.userSteps.clientFakeSteps().fakeClientUnitsBalance(LOGIN);

        Integer cost = AddRequestMap.ADD_UNITS_COST + AddRequestMap.ADD_INVALID_COST;
        assertThat("списалось правильное количество баллов", unitsAfter, equalTo(unitsBefore - cost));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("1233")
    public void addAdExtensionInvalidWsdlUnits() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);

        JSONObject request = new JSONObject();
        Object adExtensionsCallouts = new AddRequestMap().getBean();
        request.put(Path.path(AddRequestMap.AD_EXTENSIONS), adExtensionsCallouts);

        int unitsBefore = api.userSteps.clientFakeSteps().fakeClientUnitsBalance(LOGIN);
        api.userSteps.adExtensionsSteps().expectErrorOnAdd(
                request,
                new Api5Error(8000, Api5ErrorDetails.FIELD_MUST_CONTAIN_ARRAY, Path.path(AddRequestMap.AD_EXTENSIONS))
        );
        int unitsAfter = api.userSteps.clientFakeSteps().fakeClientUnitsBalance(LOGIN);

        Integer cost = AddRequestMap.ADD_INVALID_WSDL_COST;
        assertThat("списалось правильное количество баллов", unitsAfter, equalTo(unitsBefore - cost));
    }

}
