package ru.yandex.autotests.direct.api.adextensions.add;

import org.apache.commons.lang.RandomStringUtils;
import org.junit.*;
import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.adextensions.AdExtensionsFeatures;
import ru.yandex.autotests.direct.api.adextensions.AdExtensionsLogins;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.AdditionsItemDisclaimersRecord;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.common.api45mng.APIPort_PortType;
import ru.yandex.autotests.directapi.common.api45mng.CreateNewSubclientResponse;
import ru.yandex.autotests.directapi.model.Logins;
import ru.yandex.autotests.directapi.model.User;
import ru.yandex.autotests.directapi.model.api5.adextensions.AdExtensionAddItemMap;
import ru.yandex.autotests.directapi.model.api5.adextensions.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.adextensiontypes.CalloutMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;
import ru.yandex.qatools.allure.annotations.TestCaseId;

import static org.hamcrest.Matchers.notNullValue;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

/**
 * Created by ginger on 08.12.16.
 * https://st.yandex-team.ru/TESTIRT-10642
 */
@Aqua.Test
@Description("Проверка корректности работы метода при наличии дисклеймера у клиента")
@Issue("https://st.yandex-team.ru/DIRECT-59010")
@Features(AdExtensionsFeatures.ADD)
public class AddAdExtensionsDisclaimerTest {
    private static Long disclaimerId;
    private static int shardId;
    private static String MANAGER = Logins.MANAGER_DEFAULT;
    private static String LOGIN = Logins.LOGIN_FOR_USD;

    @ClassRule
    public static ApiSteps api = new ApiSteps();

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);


    @BeforeClass
    public static void prepareData() {
        api.as(MANAGER).wsdl(APIPort_PortType.class);
        shardId = api.userSteps.clientFakeSteps().getUserShard(LOGIN);
        disclaimerId = api.userSteps.getDirectJooqDbSteps().useShard(shardId)
                .bannerAdditionsSteps().saveAdditionsItemDisclaimers(
                        Long.parseLong(User.get(LOGIN).getClientID()),
                        RandomStringUtils.randomAlphanumeric(24));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("2643")
    public void successAddAdExtension() {
        api.userSteps.adExtensionsSteps().shouldGetResultOnAdExtensionsAdd(
                new AddRequestMap().withAdExtensions(
                        new AdExtensionAddItemMap()
                                .withCallout(
                                        new CalloutMap().withCalloutText(RandomStringUtils.randomAlphabetic(8))
                                )
                ),
                LOGIN,
                ExpectedResult.success()
        );
        AdditionsItemDisclaimersRecord disclaimer = api.userSteps.adExtensionsSteps().getDirectJooqDbSteps().useShard(shardId)
                .bannerAdditionsSteps().getDisclaimer(disclaimerId);
        assertThat("дисклеймер не затерся", disclaimer, notNullValue());
    }

    @AfterClass
    public static void deleteDisclaimer(){
        api.userSteps.getDirectJooqDbSteps().useShard(shardId)
                .bannerAdditionsSteps().deleteAdditionsItemDisclaimers(disclaimerId);
    }
}
