package ru.yandex.autotests.direct.api.adextensions.add;

import org.apache.commons.lang.RandomStringUtils;
import org.junit.*;
import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.adextensions.AdExtensionsFeatures;
import ru.yandex.autotests.direct.api.adextensions.AdExtensionsLogins;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.AdditionsItemCalloutsRecord;
import ru.yandex.autotests.direct.db.steps.DirectJooqDbSteps;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.api5.adextensions.AdExtensionAddItemMap;
import ru.yandex.autotests.directapi.model.api5.adextensions.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.adextensiontypes.CalloutMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.IdsCriteriaMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.equalTo;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

/**
 * Created by pavryabov on 01.04.16.
 * https://st.yandex-team.ru/TESTIRT-8603
 */
@Aqua.Test
@Description("Добавление уточнения, которое уже было добавлено и удалено")
@Issue("https://st.yandex-team.ru/DIRECT-50696")
@Features(AdExtensionsFeatures.ADD)
public class AddDeletedAdExtensionTest {

    private static final String LOGIN = AdExtensionsLogins.AD_EXTENSIONS_CLIENT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).as(LOGIN);
    private static DirectJooqDbSteps jooqDbSteps;

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private Long id;
    private String text;

    @BeforeClass
    public static void initTest() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);
        jooqDbSteps = api.userSteps.getDirectJooqDbSteps().useShardForLogin(LOGIN);
    }

    @Before
    @Step("Подготовка данных для теста")
    public void createObjects() {
        text = RandomStringUtils.randomAlphabetic(8);
        id = api.userSteps.adExtensionsSteps().addCalloutWithText(text);

    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("2160")
    public void deleteOneAdExtensionTest() {
        api.userSteps.adExtensionsSteps()
                .shouldGetResultOnDelete(new IdsCriteriaMap().withIds(id), ExpectedResult.success(id));
        AdditionsItemCalloutsRecord additionsItemCallouts = jooqDbSteps.bannerAdditionsSteps().getCallout(id);

        assumeThat("уточнение стало помечено в базе удаленным", additionsItemCallouts.getIsDeleted(), equalTo(1));
        Long newId = api.userSteps.adExtensionsSteps().shouldGetResultOnAdExtensionsAdd(
                new AddRequestMap().withAdExtensions(
                        new AdExtensionAddItemMap()
                                .withCallout(
                                        new CalloutMap().withCalloutText(text)
                                )
                ),
                ExpectedResult.success(id)
        ).getAddResults().get(0).getId();

        additionsItemCallouts = jooqDbSteps.bannerAdditionsSteps().getCallout(id);
        assertThat("уточнение стало помечено в базе неудаленным", additionsItemCallouts.getIsDeleted(), equalTo(0));

    }
}
