package ru.yandex.autotests.direct.api.adextensions.add;

import java.util.Arrays;
import java.util.Collection;

import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.junit.runners.Parameterized.Parameter;
import org.junit.runners.Parameterized.Parameters;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.adextensions.AdExtensionsFeatures;
import ru.yandex.autotests.direct.api.adextensions.AdExtensionsLogins;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetailsJava;
import ru.yandex.autotests.directapi.model.api5.adextensions.AdExtensionAddItemMap;
import ru.yandex.autotests.directapi.model.api5.adextensions.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.adextensiontypes.CalloutMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

/**
 * Created by proxeter on 17.02.16.
 * <p>
 * https://st.yandex-team.ru/TESTIRT-8603
 */
@Aqua.Test
@Description("Проверка ошибки при добавлении пустого текстового дополнения")
@Issue("https://st.yandex-team.ru/DIRECT-50696")
@Features(AdExtensionsFeatures.ADD)
@RunWith(Parameterized.class)
public class AddEmptyAdExtensionTest {

    private static final String LOGIN = AdExtensionsLogins.AD_EXTENSIONS_CLIENT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);

    @Rule
    public Trashman trashman = new Trashman(api);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Parameter(0)
    public String calloutText;

    @Parameter(1)
    public String description;

    @Parameters(name = "calloutText = <{1}>")
    public static Collection data() {
        return Arrays.asList(new Object[][]{
                {"", "empty"},
                {"  ", "space"},
                {"\t", "tab"},
                {"\n", "new line"}
        });
    }

    @Before
    public void before() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);

        api.userSteps.adExtensionsSteps().adExtensionsDelete(2810326L, 2810331L, 2810336L);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("2161")
    public void addEmptyAdExtension() {
        api.userSteps.adExtensionsSteps().shouldGetResultOnAdExtensionsAdd(
                new AddRequestMap().withAdExtensions(
                        new AdExtensionAddItemMap()
                                .withCallout(
                                        new CalloutMap().withCalloutText(calloutText)
                                )
                ),
                ExpectedResult.errors(new Notification(5003, Api5ErrorDetailsJava.CALLOUT_TEXT_IS_EMPTY))
        );
    }

}
