package ru.yandex.autotests.direct.api.adextensions.add;

import java.util.Arrays;
import java.util.Collection;

import org.apache.commons.lang.RandomStringUtils;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.adextensions.AdExtensionsFeatures;
import ru.yandex.autotests.direct.api.adextensions.AdExtensionsLogins;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5Error;
import ru.yandex.autotests.directapi.model.Logins;
import ru.yandex.autotests.directapi.model.api5.adextensions.AdExtensionAddItemMap;
import ru.yandex.autotests.directapi.model.api5.adextensions.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.adextensiontypes.CalloutMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

/**
 * Author proxeter on 14.03.16.
 * <p>
 * https://st.yandex-team.ru/TESTIRT-8603
 */
@Aqua.Test
@Features(AdExtensionsFeatures.ADD)
@Description("Проверка внутренних ролей. Позитивные сценарии")
@Issue("https://st.yandex-team.ru/DIRECT-50696")
@RunWith(Parameterized.class)
public class InternalRolesCheckRightsToAddTest {

    private static final Api5Error noRights = new Api5Error(54);

    @ClassRule
    public static ApiSteps api = new ApiSteps();

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Parameterized.Parameter(0)
    public String description;

    @Parameterized.Parameter(1)
    public String operator;

    @Parameterized.Parameter(2)
    public String client;

    @Parameterized.Parameter(3)
    public Api5Error expectedError;

    @Parameterized.Parameters(name = "{0}")
    public static Collection testData() {
        Object[][] data = new Object[][]{
                {"менеджер - сервисируемый клиент",
                        Logins.MANAGER_DEFAULT, AdExtensionsLogins.SERV_CLIENT, null},
                {"вешальщик - клиент",
                        Logins.PLACER, AdExtensionsLogins.AD_EXTENSIONS_CLIENT, noRights},
                {"саппорт - клиент",
                        Logins.SUPPORT, AdExtensionsLogins.AD_EXTENSIONS_CLIENT, null},
                //DIRECT-55677
                {"супер - сервисируемый клиент",
                        Logins.SUPER_LOGIN, AdExtensionsLogins.SERV_CLIENT, null},
                {"супер - клиент",
                        Logins.SUPER_LOGIN, AdExtensionsLogins.AD_EXTENSIONS_CLIENT, null},
                {"менеджер - субклиент",
                        AdExtensionsLogins.MANAGER_DEFAULT, AdExtensionsLogins.SUB_CLIENT_WITH_EDIT_RIGHTS,
                        null},
                {"супер - субклиент с правами редактирования",
                        Logins.SUPER_LOGIN, AdExtensionsLogins.SUB_CLIENT_WITH_EDIT_RIGHTS,
                        null},
                {"супер - субклиент без прав редактирования",
                        Logins.SUPER_LOGIN, AdExtensionsLogins.SUB_CLIENT_WITHOUT_EDIT_RIGHTS,
                        null}
        };
        return Arrays.asList(data);
    }

    @Before
    public void before() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(operator);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("2167")
    public void checkRightsToAddAdExtension() {
        api.as(operator).userSteps.adExtensionsSteps()
                .expectErrorOnAdExtensionsAdd(
                        new AddRequestMap()
                                .withAdExtensions(new AdExtensionAddItemMap()
                                        .withCallout(new CalloutMap()
                                                .withCalloutText(RandomStringUtils.randomAlphabetic(8)))),
                        client,
                        expectedError
                );
    }
}
