package ru.yandex.autotests.direct.api.adextensions.add;

import java.util.Arrays;
import java.util.Collection;

import org.apache.commons.lang.RandomStringUtils;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.adextensions.AdExtensionsFeatures;
import ru.yandex.autotests.direct.api.adextensions.AdExtensionsLogins;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5Error;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetailsJava;
import ru.yandex.autotests.directapi.model.Logins;
import ru.yandex.autotests.directapi.model.api5.adextensions.AdExtensionAddItemMap;
import ru.yandex.autotests.directapi.model.api5.adextensions.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.adextensiontypes.CalloutMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.TestCaseId;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

/**
 * Created by pavryabov on 24.03.16.
 * https://st.yandex-team.ru/TESTIRT-8603
 */
@Aqua.Test
@Features(AdExtensionsFeatures.ADD)
@Issue("https://st.yandex-team.ru/DIRECT-50696")
@RunWith(Parameterized.class)
public class InternalRolesNegativeTest {

    @ClassRule
    public static ApiSteps api = new ApiSteps();

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Parameterized.Parameter(0)
    public String description;

    @Parameterized.Parameter(1)
    public String operator;

    @Parameterized.Parameter(2)
    public String client;

    @Parameterized.Parameter(3)
    public Api5Error expectedError;

    @Parameterized.Parameters(name = "{0}")
    public static Collection testData() {
        Object[][] data = new Object[][]{
                //DIRECT-55090
                {"медиапланер - клиент",
                        Logins.MEDIA, AdExtensionsLogins.AD_EXTENSIONS_CLIENT,
                        // TODO DIRECT-72930 Api5ErrorDetails.NO_RIGHTS_TO_WRITE
                        new Api5Error(54, Api5ErrorDetails.EMPTY_STRING)},
                {"суперридер - клиент",
                        Logins.SUPER_READER, AdExtensionsLogins.AD_EXTENSIONS_CLIENT,
                        // TODO DIRECT-72930 Api5ErrorDetails.NO_RIGHTS_TO_WRITE
                        new Api5Error(54, Api5ErrorDetails.EMPTY_STRING)},
                {"менеджер - клиент",
                        Logins.MANAGER_DEFAULT, AdExtensionsLogins.AD_EXTENSIONS_CLIENT,
                        new Api5Error(8800, Api5ErrorDetails.UNKNOWN_LOGIN_IN_CLIENT_LOGIN)},
        };
        return Arrays.asList(data);
    }

    @Before
    public void clearUnits() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(operator);
    }

    @Test
    @TestCaseId("2168")
    public void checkRightsToAddCampaign() {
        //DIRECT-53552
        api.as(operator).userSteps.adExtensionsSteps().expectErrorOnAdExtensionsAdd(new AddRequestMap()
                        .withAdExtensions(new AdExtensionAddItemMap()
                                .withCallout(new CalloutMap()
                                        .withCalloutText(RandomStringUtils.randomAlphabetic(8)))),
                client,
                expectedError
        );
    }
}
