package ru.yandex.autotests.direct.api.adextensions.add;

import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.adextensions.AdExtensionsFeatures;
import ru.yandex.autotests.direct.api.adextensions.AdExtensionsLogins;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5Error;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetailsJava;
import ru.yandex.autotests.directapi.apiclient.errors.Path;
import ru.yandex.autotests.directapi.model.api5.adextensions.AddRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.TestCaseId;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

/**
 * Created by pavryabov on 24.03.16.
 * https://st.yandex-team.ru/TESTIRT-8603
 */
@Aqua.Test
@Description("Неправильный запрос")
@Issue("https://st.yandex-team.ru/DIRECT-50696")
@Features(AdExtensionsFeatures.ADD)
public class InvalidRequestTest {

    private static final String LOGIN = AdExtensionsLogins.AD_EXTENSIONS_CLIENT;


    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).as(LOGIN);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @BeforeClass
    public static void initTest() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);
    }

    @Test
    @TestCaseId("2169")
    public void emptyRequest() {
        api.userSteps.adExtensionsSteps().expectErrorOnAdExtensionsAdd(new AddRequestMap(),
                new Api5Error(8000, Api5ErrorDetailsJava.MISSING_PARAMETER_VALUE,
                        Path.path(AddRequestMap.AD_EXTENSIONS)));
    }

    @Test
    @TestCaseId("2170")
    public void emptyArrayOfAdExtensions() {
        api.userSteps.adExtensionsSteps().expectErrorOnAdExtensionsAdd(new AddRequestMap().withAdExtensions(),
                new Api5Error(8000, Api5ErrorDetailsJava.FIELD_MUST_CONTAIN_NOT_LESS_ELEMENTS,
                        Path.path(AddRequestMap.AD_EXTENSIONS), 1));
    }
}
