package ru.yandex.autotests.direct.api.adextensions.add;

import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.ApiFeatures;
import ru.yandex.autotests.direct.api.adextensions.AdExtensionsLogins;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.api5.adextensions.AdExtensionAddItemMap;
import ru.yandex.autotests.directapi.model.api5.adextensions.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.adextensiontypes.CalloutMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;
import ru.yandex.qatools.allure.annotations.TestCaseId;

import static org.apache.commons.lang3.RandomStringUtils.randomAlphabetic;

/**
 * Created by pavryabov on 24.03.16.
 * https://st.yandex-team.ru/TESTIRT-8603
 */
@Aqua.Test
@Description("Проверка работы метода под представителем клиента")
@Issue("https://st.yandex-team.ru/DIRECT-50696")
@Features(ApiFeatures.NOT_REGRESSION_YET)
@Tag(TagDictionary.NEVER_RUN)
public class RepresentativeTest {

    private static final String LOGIN = AdExtensionsLogins.AD_EXTENSIONS_CLIENT_REP;

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).as(LOGIN);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @BeforeClass
    public static void initTest() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("2171")
    public void createAdExtension() {
        api.userSteps.adExtensionsSteps().shouldGetResultOnAdExtensionsAdd(new AddRequestMap()
                        .withAdExtensions(new AdExtensionAddItemMap()
                                .withCallout(new CalloutMap()
                                        .withCalloutText(randomAlphabetic(15)))),
                ExpectedResult.success());
    }
}
