package ru.yandex.autotests.direct.api.adextensions.delete;

import org.apache.commons.lang.RandomStringUtils;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.adextensions.AdExtensionsFeatures;
import ru.yandex.autotests.direct.api.adextensions.AdExtensionsLogins;
import ru.yandex.autotests.directapi.apiclient.config.ProtocolType;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5Error;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetailsJava;
import ru.yandex.autotests.directapi.model.api5.adextensions.DeleteRequestMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.IdsCriteriaMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static ru.yandex.autotests.directapi.apiclient.errors.Path.path;

/**
 * Created by pavryabov on 30.03.16.
 * https://st.yandex-team.ru/TESTIRT-8935
 */
@Aqua.Test
@Features(AdExtensionsFeatures.DELETE)
@Description("Запросы на удаление уточнений по протоколу SOAP")
@Issue("https://st.yandex-team.ru/DIRECT-50725")
public class AdExtensionsDeleteSOAPTest {

    private static final String LOGIN = AdExtensionsLogins.AD_EXTENSIONS_CLIENT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().protocol(ProtocolType.SOAP).version(104).as(LOGIN);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private static final String DELETE_REQUEST = "DeleteRequest";

    static Long id;

    @BeforeClass
    public static void initTest() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);
        id = api.userSteps.adExtensionsSteps().addCalloutWithText(RandomStringUtils.randomAlphabetic(8));
    }

    @Test
    @Description("Валидный запрос на удаление уточнения")
    @ru.yandex.qatools.allure.annotations.TestCaseId("2174")
    public void successDeleteTest() {
        api.userSteps.adExtensionsSteps()
                .shouldGetResultOnDelete(new IdsCriteriaMap().withIds(id), ExpectedResult.success());
    }

    @Test
    @Description("Пустой запрос на удаление уточнения")
    @ru.yandex.qatools.allure.annotations.TestCaseId("2173")
    public void emptyRequest() {
        api.userSteps.adExtensionsSteps().expectErrorOnAdExtensionsDelete(new DeleteRequestMap(),
                new Api5Error(8000, Api5ErrorDetailsJava.MISSING_PARAMETER_VALUE,
                        path(DeleteRequestMap.SELECTION_CRITERIA)));
    }

    @Test
    @Description("Пустое поле SelectionCriteria в запросе на удаление уточнения")
    @ru.yandex.qatools.allure.annotations.TestCaseId("2172")
    public void emptySelectionCriteria() {
        api.userSteps.adExtensionsSteps().expectErrorOnAdExtensionsDelete(
                new DeleteRequestMap()
                        .withSelectionCriteria(new IdsCriteriaMap()
                                .withIds()),
                new Api5Error(8000, Api5ErrorDetailsJava.MISSING_PARAMETER_VALUE,
                        path(DeleteRequestMap.SELECTION_CRITERIA)));
    }
}
