package ru.yandex.autotests.direct.api.adextensions.delete;

import java.util.Arrays;
import java.util.Collection;

import org.apache.commons.lang.RandomStringUtils;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.adextensions.AdExtensionsFeatures;
import ru.yandex.autotests.direct.api.adextensions.AdExtensionsLogins;
import ru.yandex.autotests.direct.utils.model.ShardNumbers;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetailsJava;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.IdsCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

/**
 * Created by pavryabov on 31.03.16.
 * https://st.yandex-team.ru/TESTIRT-8935
 */
@Aqua.Test
@Features(AdExtensionsFeatures.DELETE)
@Description("Проверка прав доступа агентства к уточнения при его удалении")
@Issue("https://st.yandex-team.ru/DIRECT-50725")
@RunWith(Parameterized.class)
public class AgencyCheckRightsToIdTest {

    @ClassRule
    public static ApiSteps api = new ApiSteps();

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private static String client = AdExtensionsLogins.AD_EXTENSIONS_CLIENT;
    private static String agency = AdExtensionsLogins.AGENCY;
    private static String agencyRep = AdExtensionsLogins.AGENCY_REP;
    private static String agencyRepCl = AdExtensionsLogins.AGENCY_REP_CL;
    private static String subclient = AdExtensionsLogins.SUBCLIENT;
    private static String subclientElse = AdExtensionsLogins.SUBCLIENT_ELSE;

    private Long clientId;
    private Long subclientId;
    private Long subclientElseId;

    @Parameterized.Parameter(0)
    public String loginForAuthorization;

    @Parameterized.Parameters(name = "loginForAuthorization = {0}")
    public static Collection testData() {
        Object[][] data = new Object[][]{
                {agency},
                {agencyRep},
                {agencyRepCl}
        };
        return Arrays.asList(data);
    }

    @BeforeClass
    public static void beforeClass() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(client);
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(agency);
        api.userSteps.clientFakeSteps().reshardUserWithLock(subclient, ShardNumbers.DEFAULT_SHARD);
        api.userSteps.clientFakeSteps().reshardUserWithLock(subclientElse, ShardNumbers.DEFAULT_SHARD);
    }

    @Before
    public void before() {
        api.as(client);
        clientId = api.userSteps.adExtensionsSteps().addCalloutWithText(RandomStringUtils.randomAlphabetic(8));
        api.as(agency);
        subclientId =
                api.userSteps.adExtensionsSteps().addCalloutWithText(RandomStringUtils.randomAlphabetic(8), subclient);
        subclientElseId = api.userSteps.adExtensionsSteps()
                .addCalloutWithText(RandomStringUtils.randomAlphabetic(8), subclientElse);
        api.as(loginForAuthorization);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("2183")
    public void callDeleteWithSubclientId() {
        api.userSteps.adExtensionsSteps().shouldGetResultOnDelete(
                new IdsCriteriaMap().withIds(subclientId),
                subclient,
                ExpectedResult.success(subclientId)
        );
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("2184")
    public void callDeleteWithSubclientElseId() {
        api.userSteps.adExtensionsSteps().shouldGetResultOnDelete(
                new IdsCriteriaMap().withIds(subclientElseId),
                subclient,
                ExpectedResult.errors(new Notification(8800, Api5ErrorDetailsJava.AD_EXTENSION_NOT_FOUND_NO_ID))
        );
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("2182")
    public void callDeleteWithIdsOfBothSubclients() {
        api.userSteps.adExtensionsSteps().shouldGetResultOnDelete(
                new IdsCriteriaMap().withIds(subclientId, subclientElseId),
                subclient,
                ExpectedResult.success(subclientId),
                ExpectedResult.errors(new Notification(8800, Api5ErrorDetailsJava.AD_EXTENSION_NOT_FOUND_NO_ID))
        );
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("2185")
    public void callDeleteWithClientId() {
        api.userSteps.adExtensionsSteps().shouldGetResultOnDelete(
                new IdsCriteriaMap().withIds(clientId),
                subclient,
                ExpectedResult.errors(new Notification(8800, Api5ErrorDetailsJava.AD_EXTENSION_NOT_FOUND_NO_ID))
        );
    }
}
