package ru.yandex.autotests.direct.api.adextensions.delete;

import java.sql.Timestamp;

import org.apache.commons.lang.RandomStringUtils;
import org.joda.time.DateTime;
import org.junit.*;
import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.adextensions.AdExtensionsFeatures;
import ru.yandex.autotests.direct.api.adextensions.AdExtensionsLogins;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.AdditionsItemCalloutsRecord;
import ru.yandex.autotests.direct.db.steps.DirectJooqDbSteps;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.IdsCriteriaMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.equalTo;
import static org.hamcrest.Matchers.not;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

/**
 * Created by pavryabov on 31.03.16.
 * https://st.yandex-team.ru/TESTIRT-8935
 */
@Aqua.Test
@Features(AdExtensionsFeatures.DELETE)
@Description("Проверка изменения last_change при удалении уточнения")
@Issue("https://st.yandex-team.ru/DIRECT-50725")
public class CheckLastChangeDeleteAdExtensionsTest {

    private static final String LOGIN = AdExtensionsLogins.AD_EXTENSIONS_CLIENT;
    private static final String PATTERN = "yyyy'-'MM'-'dd HH':'mm':'ss.S";

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).as(LOGIN);
    private static DirectJooqDbSteps jooqDbSteps;

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private Long id;
    private Timestamp lastChange;


    @BeforeClass
    public static void initTest() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);
        jooqDbSteps = api.userSteps.getDirectJooqDbSteps().useShardForLogin(LOGIN);
    }

    @Before
    @Step("Подготовка данных для теста")
    public void createObjects() {
        id = api.userSteps.adExtensionsSteps().addCalloutWithText(RandomStringUtils.randomAlphabetic(8));
        lastChange = new Timestamp(DateTime.now().minusHours(1).getMillis());
        AdditionsItemCalloutsRecord additionsItemCallouts = jooqDbSteps.bannerAdditionsSteps().getCallout(id);

        jooqDbSteps.bannerAdditionsSteps().setAdditionsItemCalloutsLastChange(id, lastChange);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("2186")
    public void deleteAdExtensionAndCheckLastChange() {
        api.userSteps.adExtensionsSteps()
                .shouldGetResultOnDelete(new IdsCriteriaMap().withIds(id), ExpectedResult.success(id));
        AdditionsItemCalloutsRecord additionsItemCallouts = jooqDbSteps.bannerAdditionsSteps().getCallout(id);
        assertThat("lastChange изменился", additionsItemCallouts.getLastChange(), not(equalTo(lastChange)));
    }
}
