package ru.yandex.autotests.direct.api.adextensions.delete;

import org.apache.commons.lang.RandomStringUtils;
import org.junit.*;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.adextensions.AdExtensionsFeatures;
import ru.yandex.autotests.direct.api.adextensions.AdExtensionsLogins;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.AdditionsItemCalloutsStatusmoderate;
import ru.yandex.autotests.direct.db.steps.DirectJooqDbSteps;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.IdsCriteriaMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import java.util.Arrays;
import java.util.Collection;

/**
 * Created by pavryabov on 31.03.16.
 * https://st.yandex-team.ru/TESTIRT-8935
 */
@Aqua.Test
@Features(AdExtensionsFeatures.DELETE)
@Description("Удаление уточнения в разных статусах")
@Issue("https://st.yandex-team.ru/DIRECT-50725")
@RunWith(Parameterized.class)
public class DeleteAdExtensionsOfDifferentStatusesTest {

    private static final String LOGIN = AdExtensionsLogins.AD_EXTENSIONS_CLIENT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);
    private static DirectJooqDbSteps jooqDbSteps;

    @Rule
    public Trashman trashman = new Trashman(api);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    private Long id;

    @Parameterized.Parameter(value = 0)
    public AdditionsItemCalloutsStatusmoderate statusModerate;

    @Parameterized.Parameters(name = "dbStatus = {0}")
    public static Collection testData() {
        Object[][] data = new Object[][]{
                {AdditionsItemCalloutsStatusmoderate.New},
                {AdditionsItemCalloutsStatusmoderate.Sent},
                {AdditionsItemCalloutsStatusmoderate.Sending},
                {AdditionsItemCalloutsStatusmoderate.Ready},
                {AdditionsItemCalloutsStatusmoderate.Yes},
                {AdditionsItemCalloutsStatusmoderate.No}
        };
        return Arrays.asList(data);
    }

    @BeforeClass
    public static void initTest() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);
        jooqDbSteps = api.userSteps.getDirectJooqDbSteps().useShardForLogin(LOGIN);
    }

    @Before
    public void before() {
        id = api.userSteps.adExtensionsSteps().addCalloutWithText(RandomStringUtils.randomAlphabetic(8));
        jooqDbSteps.bannerAdditionsSteps().setAdditionsItemCalloutsStatusModerated(id, statusModerate);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("2187")
    public void deleteAdExtension() {
        api.userSteps.adExtensionsSteps()
                .shouldGetResultOnDelete(new IdsCriteriaMap().withIds(id), ExpectedResult.success(id));
        ;
    }
}
