package ru.yandex.autotests.direct.api.adextensions.delete;

import org.apache.commons.lang.RandomStringUtils;
import org.junit.*;
import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.AdditionsItemCalloutsRecord;
import ru.yandex.autotests.direct.db.steps.DirectJooqDbSteps;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.direct.api.adextensions.AdExtensionsFeatures;
import ru.yandex.autotests.direct.api.adextensions.AdExtensionsLogins;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.IdsCriteriaMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.equalTo;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

/**
 * Created by pavryabov on 30.03.16.
 * https://st.yandex-team.ru/TESTIRT-8935
 */
@Aqua.Test
@Features(AdExtensionsFeatures.DELETE)
@Description("Удаление одного или нескольких уточнений")
@Issue("https://st.yandex-team.ru/DIRECT-50725")
@Tag(TagDictionary.TRUNK)
public class DeleteAdExtensionsTest {

    private static final String LOGIN = AdExtensionsLogins.AD_EXTENSIONS_CLIENT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).as(LOGIN);
    private static DirectJooqDbSteps jooqDbSteps;

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private Long id1;
    private Long id2;

    @BeforeClass
    public static void initTest() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);
        jooqDbSteps = api.userSteps.getDirectJooqDbSteps().useShardForLogin(LOGIN);
    }

    @Before
    @Step("Подготовка данных для теста")
    public void createObjects() {
        id1 = api.userSteps.adExtensionsSteps().addCalloutWithText(RandomStringUtils.randomAlphabetic(8));
        id2 = api.userSteps.adExtensionsSteps().addCalloutWithText(RandomStringUtils.randomAlphabetic(8));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("2188")
    public void deleteOneAdExtensionTest() {
        api.userSteps.adExtensionsSteps()
                .shouldGetResultOnDelete(new IdsCriteriaMap().withIds(id1), ExpectedResult.success(id1));
        AdditionsItemCalloutsRecord additionsItemCallouts = jooqDbSteps.bannerAdditionsSteps().getCallout(id1);

        assertThat("уточнение стало помечено в базе удаленным", additionsItemCallouts.getIsDeleted(), equalTo(1));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("2189")
    public void deleteTwoAdExtensionsTest() {
        api.userSteps.adExtensionsSteps()
                .shouldGetResultOnDelete(new IdsCriteriaMap().withIds(id1, id2),
                        ExpectedResult.success(id1), ExpectedResult.success(id2));
        AdditionsItemCalloutsRecord additionsItemCallouts = jooqDbSteps.bannerAdditionsSteps().getCallout(id1);
        assertThat("уточнение стало помечено в базе удаленным", additionsItemCallouts.getIsDeleted(), equalTo(1));
        additionsItemCallouts = jooqDbSteps.bannerAdditionsSteps().getCallout(id2);
        assertThat("уточнение стало помечено в базе удаленным", additionsItemCallouts.getIsDeleted(), equalTo(1));
    }
}
