package ru.yandex.autotests.direct.api.adextensions.delete;

import com.yandex.direct.api.v5.general.OperationEnum;
import org.apache.commons.lang.RandomStringUtils;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import ru.yandex.qatools.allure.annotations.TestCaseId;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.adextensions.AdExtensionsFeatures;
import ru.yandex.autotests.direct.api.adextensions.AdExtensionsLogins;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetailsJava;
import ru.yandex.autotests.directapi.model.api5.adextensiontypes.AdExtensionSettingItemMap;
import ru.yandex.autotests.directapi.model.api5.adextensiontypes.AdExtensionSettingMap;
import ru.yandex.autotests.directapi.model.api5.ads.AdAddItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.AdUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.TextAdAddMap;
import ru.yandex.autotests.directapi.model.api5.ads.TextAdUpdateMap;
import ru.yandex.autotests.directapi.model.api5.ads.UpdateRequestMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.IdsCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

/**
 * Created by pavryabov on 31.03.16.
 * https://st.yandex-team.ru/TESTIRT-8935
 */
@Aqua.Test
@Features(AdExtensionsFeatures.DELETE)
@Description("Удаление привязанных уточнений")
@Issue("https://st.yandex-team.ru/DIRECT-50725")
public class DeleteLinkedAdExtensionsTest {

    private static final String LOGIN = AdExtensionsLogins.AD_EXTENSIONS_CLIENT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).as(LOGIN);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private Long adGroupId;
    private Long id;
    private Long adId;
    private Long campaignId;

    @BeforeClass
    public static void initTest() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);
    }

    @Before
    @Step("Подготовка данных для теста")
    public void createAd() {
        campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign();
        adGroupId = api.userSteps.adGroupsSteps().addDefaultGroup(campaignId);
        id = api.userSteps.adExtensionsSteps().addCalloutWithText(RandomStringUtils.randomAlphabetic(8));
        adId = api.userSteps.adsSteps().addAd(new AdAddItemMap()
                .withAdGroupId(adGroupId)
                .withTextAd(new TextAdAddMap()
                        .defaultTextAd()
                        .withAdExtensionIds(id)));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("2190")
    public void deleteLinkedId() {
        api.userSteps.adExtensionsSteps()
                .shouldGetResultOnDelete(new IdsCriteriaMap().withIds(id),
                        ExpectedResult.errors(new Notification(8301,
                                Api5ErrorDetailsJava.UNABLE_TO_DELETE_LINKED_AD_EXTENSION)));
    }

    @Test
    @TestCaseId("2958")
    public void deleteLinkedWithMultipleId() {
        for (int i = 0; i < 10; i++) {
            adId = api.userSteps.adsSteps().addAd(new AdAddItemMap()
                    .withAdGroupId(adGroupId)
                    .withTextAd(new TextAdAddMap().defaultTextAd().withAdExtensionIds(id)));
        }
        api.userSteps.adExtensionsSteps()
                .shouldGetResultOnDelete(new IdsCriteriaMap().withIds(id),
                        ExpectedResult.errors(new Notification(8301,
                                Api5ErrorDetailsJava.UNABLE_TO_DELETE_LINKED_AD_EXTENSION)));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("2191")
    public void deleteUnlinkedId() {
        api.userSteps.adsSteps().adsUpdate(new UpdateRequestMap()
                .withAds(new AdUpdateItemMap()
                        .withId(adId)
                        .withTextAd(new TextAdUpdateMap()
                                .withCalloutSetting(new AdExtensionSettingMap()
                                        .withAdExtensions(new AdExtensionSettingItemMap()
                                                .withAdExtensionId(id)
                                                .withOperation(OperationEnum.REMOVE))))));
        api.userSteps.adExtensionsSteps()
                .shouldGetResultOnDelete(new IdsCriteriaMap().withIds(id), ExpectedResult.success());
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("2192")
    public void deleteIdLinkedToDeletedAd() {
        api.userSteps.adsSteps().adsDelete(adId);
        api.userSteps.adExtensionsSteps()
                .shouldGetResultOnDelete(new IdsCriteriaMap().withIds(id), ExpectedResult.success());
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("2193")
    public void deleteIdLinkedToAdFromDeletedCampaign() {
        //DIRECT-53953
        api.userSteps.campaignSteps().campaignsDelete(campaignId);
        api.userSteps.adExtensionsSteps()
                .shouldGetResultOnDelete(new IdsCriteriaMap().withIds(id), ExpectedResult.success());
    }
}
