package ru.yandex.autotests.direct.api.adextensions.delete;

import org.apache.commons.lang.RandomStringUtils;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.adextensions.AdExtensionsFeatures;
import ru.yandex.autotests.direct.api.adextensions.AdExtensionsLogins;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetailsJava;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.IdsCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

/**
 * Created by pavryabov on 31.03.16.
 * https://st.yandex-team.ru/TESTIRT-8935
 */
@Aqua.Test
@Features(AdExtensionsFeatures.DELETE)
@Description("Пообъектная обработка запроса")
@Issue("https://st.yandex-team.ru/DIRECT-50725")
public class DiscreteValidationTest {

    private static final String LOGIN = AdExtensionsLogins.AD_EXTENSIONS_CLIENT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).as(LOGIN);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private Long id;

    @Before
    @Step("Подготовка данных для теста")
    public void initTest() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);
        id = api.userSteps.adExtensionsSteps().addCalloutWithText(RandomStringUtils.randomAlphabetic(8));
    }

    @Test
    @Description("Удалить валидное и невалидное уточнения")
    @ru.yandex.qatools.allure.annotations.TestCaseId("2194")
    public void deleteValidAndInvalidAdExtensions() {
        api.userSteps.adExtensionsSteps()
                .shouldGetResultOnDelete(new IdsCriteriaMap().withIds(id, -1L),
                        ExpectedResult.success(id),
                        ExpectedResult.errors(new Notification(5005,
                                Api5ErrorDetailsJava.ID_MUST_BE_POSITIVE_INTEGER)));
    }

    @Test
    @Description("Удалить невалидное и валидное уточнения")
    @ru.yandex.qatools.allure.annotations.TestCaseId("2195")
    public void deleteInvalidAndValidAdExtensions() {
        api.userSteps.adExtensionsSteps()
                .shouldGetResultOnDelete(new IdsCriteriaMap().withIds(-1L, id),
                        ExpectedResult.errors(new Notification(5005,
                                Api5ErrorDetailsJava.ID_MUST_BE_POSITIVE_INTEGER)),
                        ExpectedResult.success(id));
    }

    @Test
    @Description("Удалить два невалидных уточнения")
    @ru.yandex.qatools.allure.annotations.TestCaseId("2196")
    public void deleteTwoInvalidAdExtensions() {
        api.userSteps.adExtensionsSteps()
                .shouldGetResultOnDelete(new IdsCriteriaMap().withIds(-1L, -2L),
                        ExpectedResult.errors(new Notification(5005,
                                Api5ErrorDetailsJava.ID_MUST_BE_POSITIVE_INTEGER)),
                        ExpectedResult.errors(new Notification(5005,
                                Api5ErrorDetailsJava.ID_MUST_BE_POSITIVE_INTEGER)));
    }
}
