package ru.yandex.autotests.direct.api.adextensions.delete;

import org.apache.commons.lang.RandomStringUtils;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.adextensions.AdExtensionsFeatures;
import ru.yandex.autotests.direct.api.adextensions.AdExtensionsLogins;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5Error;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.model.Logins;
import ru.yandex.autotests.directapi.model.api5.adextensions.DeleteRequestMap;
import ru.yandex.autotests.directapi.model.api5.general.IdsCriteriaMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.hazelcast.SemaphoreRule;
import ru.yandex.qatools.allure.annotations.TestCaseId;

import java.util.Arrays;
import java.util.Collection;

/**
 * Created by pavryabov on 01.04.16.
 * https://st.yandex-team.ru/TESTIRT-8935
 */
@Aqua.Test
@Features(AdExtensionsFeatures.DELETE)
@Description("Проверка прав внутренних ролей на удаление уточнений")
@Issue("https://st.yandex-team.ru/DIRECT-50725")
@RunWith(Parameterized.class)
public class InternalRolesNegativeTest {
    //DIRECT-52731

    @ClassRule
    public static ApiSteps api = new ApiSteps();

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private static String servClient = AdExtensionsLogins.SERV_CLIENT;

    private Long id;

    @Parameterized.Parameter(0)
    public String loginForAuthorization;

    @Parameterized.Parameters(name = "loginForAuthorization = {0}")
    public static Collection testData() {
        Object[][] data = new Object[][]{
                {Logins.MEDIA},
                {Logins.SUPER_READER}
        };
        return Arrays.asList(data);
    }

    @Before
    @Step("Подготовка данных для теста")
    public void prepareData() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(servClient);
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(loginForAuthorization);
        id = api.userSteps.adExtensionsSteps().addCalloutWithText(RandomStringUtils.randomAlphabetic(8), servClient);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("2204")
    public void checkRightsToDelete() {
        api.as(loginForAuthorization).userSteps.adExtensionsSteps().expectErrorOnAdExtensionsDelete(
                new DeleteRequestMap().withSelectionCriteria(new IdsCriteriaMap().withIds(id)), servClient,
                // TODO DIRECT-72930 Api5ErrorDetails.NO_RIGHTS_TO_WRITE
                new Api5Error(54, Api5ErrorDetails.EMPTY_STRING)
        );
    }
}
