package ru.yandex.autotests.direct.api.adextensions.delete;

import org.apache.commons.lang.RandomStringUtils;
import org.json.simple.JSONObject;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.adextensions.AdExtensionsFeatures;
import ru.yandex.autotests.direct.api.adextensions.AdExtensionsLogins;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5Error;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetailsJava;
import ru.yandex.autotests.directapi.model.api5.adextensions.DeleteRequestMap;
import ru.yandex.autotests.directapi.model.api5.general.IdsCriteriaMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.apache.commons.lang3.StringUtils.capitalize;
import static ru.yandex.autotests.directapi.apiclient.errors.Path.path;

/**
 * Created by pavryabov on 31.03.16.
 * https://st.yandex-team.ru/TESTIRT-8935
 */
@Aqua.Test
@Features(AdExtensionsFeatures.DELETE)
@Description("Неправильный формат JSON-запроса на удаление уточнения")
@Issue("https://st.yandex-team.ru/DIRECT-50725")
public class InvalidJSONTest {

    private static final String LOGIN = AdExtensionsLogins.AD_EXTENSIONS_CLIENT;

    @ClassRule
    public static final ApiSteps api = new ApiSteps().version(104).as(LOGIN);

    @ClassRule
    public static final SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private static Long id;

    @BeforeClass
    public static void initTest() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);
        id = api.userSteps.adExtensionsSteps().addCalloutWithText(RandomStringUtils.randomAlphabetic(8));
    }

    @Test
    @Description("Невалидное значение в params")
    @ru.yandex.qatools.allure.annotations.TestCaseId("2207")
    public void invalidFieldInParams() {
        JSONObject request = new JSONObject();
        JSONObject idsCriteria = new JSONObject();
        idsCriteria.put(capitalize(IdsCriteriaMap.IDS), new Object[]{id});
        request.put(DeleteRequestMap.SELECTION_CRITERIA, idsCriteria);
        api.userSteps.adExtensionsSteps().expectErrorOnAdExtensionsDelete(
                request,
                new Api5Error(8000, Api5ErrorDetailsJava.MISSING_PARAMETER_VALUE,
                        capitalize(DeleteRequestMap.SELECTION_CRITERIA))
        );
    }

    @Test
    @Description("Невалидное значение в SelectionCriteria")
    @ru.yandex.qatools.allure.annotations.TestCaseId("2208")
    public void invalidFieldInSelectionCriteria() {
        JSONObject request = new JSONObject();
        JSONObject idsCriteria = new JSONObject();
        idsCriteria.put(IdsCriteriaMap.IDS, new Object[]{id});
        request.put(capitalize(DeleteRequestMap.SELECTION_CRITERIA), idsCriteria);
        api.userSteps.adExtensionsSteps().expectErrorOnAdExtensionsDelete(
                request,
                new Api5Error(8000, Api5ErrorDetailsJava.MISSING_PARAMETER_VALUE,
                        capitalize(IdsCriteriaMap.IDS))
        );
    }

    @Test
    @Description("Массив в params")
    @ru.yandex.qatools.allure.annotations.TestCaseId("2206")
    public void arrayInParams() {
        JSONObject request = new JSONObject();
        JSONObject idsCriteria = new JSONObject();
        idsCriteria.put(capitalize(IdsCriteriaMap.IDS), new Object[]{id});
        request.put(capitalize(DeleteRequestMap.SELECTION_CRITERIA), idsCriteria);
        api.userSteps.adExtensionsSteps().expectErrorOnAdExtensionsDelete(
                new Object[]{request},
                new Api5Error(8000, Api5ErrorDetailsJava.INVALID_REQUEST_FORMAT)
        );
    }

    @Test
    @Description("Массив в SelectionCriteria")
    @ru.yandex.qatools.allure.annotations.TestCaseId("2209")
    public void arrayInSelectionCriteria() {
        JSONObject request = new JSONObject();
        JSONObject idsCriteria = new JSONObject();
        idsCriteria.put(capitalize(IdsCriteriaMap.IDS), new Object[]{id});
        request.put(capitalize(DeleteRequestMap.SELECTION_CRITERIA), new Object[]{idsCriteria});
        api.userSteps.adExtensionsSteps().expectErrorOnAdExtensionsDelete(
                request,
                new Api5Error(8000, Api5ErrorDetailsJava.FIELD_MUST_NOT_CONTAIN_ARRAY,
                        path(DeleteRequestMap.SELECTION_CRITERIA))
        );
    }

    @Test
    @Description("Не массив в Ids")
    @ru.yandex.qatools.allure.annotations.TestCaseId("2205")
    public void notArrayInIds() {
        JSONObject request = new JSONObject();
        JSONObject idsCriteria = new JSONObject();
        idsCriteria.put(capitalize(IdsCriteriaMap.IDS), id);
        request.put(capitalize(DeleteRequestMap.SELECTION_CRITERIA), idsCriteria);
        api.userSteps.adExtensionsSteps().expectErrorOnAdExtensionsDelete(
                request,
                new Api5Error(8000, Api5ErrorDetailsJava.FIELD_MUST_CONTAIN_ARRAY,
                        path(DeleteRequestMap.SELECTION_CRITERIA, IdsCriteriaMap.IDS))
        );
    }

    @Test
    @Description("Строка в массиве Ids")
    @ru.yandex.qatools.allure.annotations.TestCaseId("2210")
    public void arrayOfStringsInIds() {
        JSONObject request = new JSONObject();
        JSONObject idsCriteria = new JSONObject();
        idsCriteria.put(capitalize(IdsCriteriaMap.IDS), new Object[]{"string"});
        request.put(capitalize(DeleteRequestMap.SELECTION_CRITERIA), idsCriteria);
        api.userSteps.adExtensionsSteps().expectErrorOnAdExtensionsDelete(
                request,
                new Api5Error(8000, Api5ErrorDetailsJava.ELEMENT_OF_ARRAY_MUST_CONTAIN_INTEGER_VALUE,
                        path(DeleteRequestMap.SELECTION_CRITERIA, IdsCriteriaMap.IDS))
        );
    }
}
