package ru.yandex.autotests.direct.api.adextensions.delete;

import java.util.Arrays;

import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.adextensions.AdExtensionsFeatures;
import ru.yandex.autotests.direct.api.adextensions.AdExtensionsLogins;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5Error;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetailsJava;
import ru.yandex.autotests.directapi.model.api5.adextensions.DeleteRequestMap;
import ru.yandex.autotests.directapi.model.api5.general.IdsCriteriaMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.apache.commons.lang3.StringUtils.capitalize;
import static ru.yandex.autotests.directapi.apiclient.errors.Path.path;

/**
 * Created by pavryabov on 31.03.16.
 * https://st.yandex-team.ru/TESTIRT-8935
 */
@Aqua.Test
@Features(AdExtensionsFeatures.DELETE)
@Description("Неправильный запрос на удаление уточнений")
@Issue("https://st.yandex-team.ru/DIRECT-50725")
public class InvalidRequestTest {

    private static final String LOGIN = AdExtensionsLogins.AD_EXTENSIONS_CLIENT;

    @ClassRule
    public static final ApiSteps api = new ApiSteps().version(104).as(LOGIN);

    @ClassRule
    public static final SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Before
    public void addUnitsToClient() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);
    }

    @Test
    @Description("Пустой запрос")
    @ru.yandex.qatools.allure.annotations.TestCaseId("2213")
    public void emptyRequest() {
        api.userSteps.adExtensionsSteps().expectErrorOnAdExtensionsDelete(new DeleteRequestMap(),
                new Api5Error(8000, Api5ErrorDetailsJava.MISSING_PARAMETER_VALUE,
                        path(DeleteRequestMap.SELECTION_CRITERIA)));
    }

    @Test
    @Description("Пустой массив SelectionCriteria")
    @ru.yandex.qatools.allure.annotations.TestCaseId("2212")
    public void emptySelectionCriteria() {
        api.userSteps.adExtensionsSteps().expectErrorOnAdExtensionsDelete(
                new DeleteRequestMap().withSelectionCriteria(new IdsCriteriaMap()),
                new Api5Error(8000, Api5ErrorDetailsJava.MISSING_PARAMETER_VALUE,
                        capitalize(IdsCriteriaMap.IDS)));
    }

    @Test
    @Description("Пустой массив Ids")
    @ru.yandex.qatools.allure.annotations.TestCaseId("2211")
    public void emptyArrayOfIds() {
        api.userSteps.adExtensionsSteps().expectErrorOnAdExtensionsDelete(
                new DeleteRequestMap().withSelectionCriteria(new IdsCriteriaMap().withIds()),
                new Api5Error(8000, Api5ErrorDetailsJava.FIELD_MUST_CONTAIN_NOT_LESS_ELEMENTS,
                        path(DeleteRequestMap.SELECTION_CRITERIA, IdsCriteriaMap.IDS), 1));
    }

    @Test
    @Description("Удалить объявления за один запрос, число которых больше " + IdsCriteriaMap.IDS_MAX_LENGTH)
    @ru.yandex.qatools.allure.annotations.TestCaseId("2214")
    public void delete10001AdExtensions() {
        Long[] ids = new Long[IdsCriteriaMap.IDS_MAX_LENGTH + 1];
        Arrays.fill(ids, 0L);
        api.userSteps.adExtensionsSteps().expectErrorOnAdExtensionsDelete(
                new DeleteRequestMap().withSelectionCriteria(new IdsCriteriaMap().withIds(ids)),
                new Api5Error(4001,
                        Api5ErrorDetailsJava.ENABLE_DELETE_NO_MORE_ADEXTENSIONS_FOR_OPERATION,
                        IdsCriteriaMap.IDS_MAX_LENGTH)
        );
    }
}
