package ru.yandex.autotests.direct.api.adextensions.delete;

import org.apache.commons.lang.RandomStringUtils;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.ApiFeatures;
import ru.yandex.autotests.direct.api.adextensions.AdExtensionsLogins;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.IdsCriteriaMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;
import ru.yandex.qatools.allure.annotations.TestCaseId;

/**
 * Created by pavryabov on 31.03.16.
 * https://st.yandex-team.ru/TESTIRT-8935
 */
@Aqua.Test
@Features(ApiFeatures.NOT_REGRESSION_YET)
@Description("Проверка работы метода под представителем клиента")
@Issue("https://st.yandex-team.ru/DIRECT-50725")
@Tag(TagDictionary.NEVER_RUN)
public class RepresentativeTest {

    private static final String LOGIN = AdExtensionsLogins.AD_EXTENSIONS_CLIENT_REP;

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).as(LOGIN);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    static Long id;

    @BeforeClass
    public static void initTest() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);
        id = api.userSteps.adExtensionsSteps().addCalloutWithText(RandomStringUtils.randomAlphabetic(8));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("2215")
    public void deleteAdExtension() {
        api.userSteps.adExtensionsSteps()
                .shouldGetResultOnDelete(new IdsCriteriaMap().withIds(id), ExpectedResult.success(id));
    }
}
