package ru.yandex.autotests.direct.api.adextensions.get;

import com.yandex.direct.api.v5.adextensions.AdExtensionFieldEnum;
import com.yandex.direct.api.v5.adextensions.AdExtensionGetItem;
import com.yandex.direct.api.v5.adextensions.AddResponse;
import com.yandex.direct.api.v5.adextensions.GetResponse;
import com.yandex.direct.api.v5.adextensiontypes.AdExtensionTypeEnum;
import org.apache.commons.lang.RandomStringUtils;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.adextensions.AdExtensionsFeatures;
import ru.yandex.autotests.direct.api.adextensions.AdExtensionsLogins;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5Error;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.model.api5.adextensions.AdExtensionAddItemMap;
import ru.yandex.autotests.directapi.model.api5.adextensions.AdExtensionsSelectionCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.adextensions.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.adextensions.GetRequestMap;
import ru.yandex.autotests.directapi.model.api5.adextensiontypes.CalloutMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.LimitOffsetMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.hazelcast.SemaphoreRule;
import ru.yandex.qatools.allure.annotations.TestCaseId;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

import static org.hamcrest.MatcherAssert.assertThat;
import static org.hamcrest.Matchers.*;
import static ru.yandex.autotests.irt.testutils.beandiffer2.BeanDifferMatcher.beanDiffer;

/**
 * Created by proxeter on 22.03.16.
 * <p>
 * https://st.yandex-team.ru/TESTIRT-8603
 */
@Aqua.Test
@Features(AdExtensionsFeatures.GET)
@Description("Проверка пагинации при получении текстового дополнения")
@Issue("https://st.yandex-team.ru/DIRECT-50724")
public class AdExtensionsPagerTest {

    private static String client = AdExtensionsLogins.AD_EXTENSIONS_CLIENT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(client);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private static Long id1;
    private static Long id2;
    private static Long id3;
    private static Long id4;

    @BeforeClass
    @Step("Подготовка данных для теста")
    public static void beforeClass() {
        AddResponse addResponse = api.userSteps.adExtensionsSteps().shouldGetResultOnAdExtensionsAdd(
                new AddRequestMap().withAdExtensions(
                        new AdExtensionAddItemMap()
                                .withCallout(
                                        new CalloutMap().withCalloutText(RandomStringUtils.random(8, true, false))
                                ),
                        new AdExtensionAddItemMap()
                                .withCallout(
                                        new CalloutMap().withCalloutText(RandomStringUtils.random(8, true, false))
                                ),
                        new AdExtensionAddItemMap()
                                .withCallout(
                                        new CalloutMap().withCalloutText(RandomStringUtils.random(8, true, false))
                                ),
                        new AdExtensionAddItemMap()
                                .withCallout(
                                        new CalloutMap().withCalloutText(RandomStringUtils.random(8, true, false))
                                )
                ),
                ExpectedResult.success(),
                ExpectedResult.success(),
                ExpectedResult.success(),
                ExpectedResult.success()
        );

        addResponse.getAddResults().sort((x, y) -> x.getId().compareTo(y.getId()));

        id1 = addResponse.getAddResults().get(0).getId();
        id2 = addResponse.getAddResults().get(1).getId();
        id3 = addResponse.getAddResults().get(2).getId();
        id4 = addResponse.getAddResults().get(3).getId();
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("2217")
    public void getHead() {
        GetResponse getResponse = api.userSteps.adExtensionsSteps().getAdExtensions(
                new GetRequestMap()
                        .withFieldNames(AdExtensionFieldEnum.values())
                        .withSelectionCriteria(
                                new AdExtensionsSelectionCriteriaMap()
                                        .withIds(id1, id2, id3, id4)
                                        .withTypes(AdExtensionTypeEnum.CALLOUT)
                        )
                        .withPage(
                                new LimitOffsetMap()
                                        .withOffset(0L)
                                        .withLimit(2L)
                        )
        );

        List<Long> ids =
                getResponse.getAdExtensions().stream().map(AdExtensionGetItem::getId).collect(Collectors.toList());

        assertThat("получено два текстовых дополнения", ids, beanDiffer(Arrays.asList(id1, id2)));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("2218")
    public void getBody() {
        GetResponse getResponse = api.userSteps.adExtensionsSteps().getAdExtensions(
                new GetRequestMap()
                        .withFieldNames(AdExtensionFieldEnum.values())
                        .withSelectionCriteria(
                                new AdExtensionsSelectionCriteriaMap()
                                        .withIds(id1, id2, id3, id4)
                                        .withTypes(AdExtensionTypeEnum.CALLOUT)
                        )
                        .withPage(
                                new LimitOffsetMap()
                                        .withOffset(1L)
                                        .withLimit(2L)
                        )
        );

        List<Long> ids =
                getResponse.getAdExtensions().stream().map(AdExtensionGetItem::getId).collect(Collectors.toList());

        assertThat("получено два текстовых дополнения", ids, beanDiffer(Arrays.asList(id2, id3)));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("2216")
    public void getTail() {
        GetResponse getResponse = api.userSteps.adExtensionsSteps().getAdExtensions(
                new GetRequestMap()
                        .withFieldNames(AdExtensionFieldEnum.values())
                        .withSelectionCriteria(
                                new AdExtensionsSelectionCriteriaMap()
                                        .withIds(id1, id2, id3, id4)
                                        .withTypes(AdExtensionTypeEnum.CALLOUT)
                        )
                        .withPage(
                                new LimitOffsetMap()
                                        .withOffset(2L)
                                        .withLimit(2L)
                        )
        );

        List<Long> ids =
                getResponse.getAdExtensions().stream().map(AdExtensionGetItem::getId).collect(Collectors.toList());

        assertThat("получено два текстовых дополнения", ids, beanDiffer(Arrays.asList(id3, id4)));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("2224")
    public void getPartOfTail() {
        GetResponse getResponse = api.userSteps.adExtensionsSteps().getAdExtensions(
                new GetRequestMap()
                        .withFieldNames(AdExtensionFieldEnum.values())
                        .withSelectionCriteria(
                                new AdExtensionsSelectionCriteriaMap()
                                        .withIds(id1, id2, id3, id4)
                                        .withTypes(AdExtensionTypeEnum.CALLOUT)
                        )
                        .withPage(
                                new LimitOffsetMap()
                                        .withOffset(3L)
                                        .withLimit(2L)
                        )
        );

        List<Long> ids =
                getResponse.getAdExtensions().stream().map(AdExtensionGetItem::getId).collect(Collectors.toList());

        assertThat("получено два текстовых дополнения", ids, beanDiffer(Arrays.asList(id4)));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("2225")
    public void getOverTail() {
        GetResponse getResponse = api.userSteps.adExtensionsSteps().getAdExtensions(
                new GetRequestMap()
                        .withFieldNames(AdExtensionFieldEnum.values())
                        .withSelectionCriteria(
                                new AdExtensionsSelectionCriteriaMap()
                                        .withIds(id1, id2, id3, id4)
                                        .withTypes(AdExtensionTypeEnum.CALLOUT)
                        )
                        .withPage(
                                new LimitOffsetMap()
                                        .withOffset(4L)
                                        .withLimit(2L)
                        )
        );

        assertThat("получено два текстовых дополнения", getResponse.getAdExtensions(), hasSize(0));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("2223")
    public void onlyLimit() {
        GetResponse getResponse = api.userSteps.adExtensionsSteps().getAdExtensions(
                new GetRequestMap()
                        .withFieldNames(AdExtensionFieldEnum.values())
                        .withSelectionCriteria(
                                new AdExtensionsSelectionCriteriaMap()
                                        .withIds(id1, id2, id3, id4)
                                        .withTypes(AdExtensionTypeEnum.CALLOUT)
                        )
                        .withPage(
                                new LimitOffsetMap()
                                        .withLimit(2L)
                        )
        );

        List<Long> ids =
                getResponse.getAdExtensions().stream().map(AdExtensionGetItem::getId).collect(Collectors.toList());

        assertThat("получено два текстовых дополнения", ids, beanDiffer(Arrays.asList(id1, id2)));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("2222")
    public void onlyOffset() {
        GetResponse getResponse = api.userSteps.adExtensionsSteps().getAdExtensions(
                new GetRequestMap()
                        .withFieldNames(AdExtensionFieldEnum.values())
                        .withSelectionCriteria(
                                new AdExtensionsSelectionCriteriaMap()
                                        .withIds(id1, id2, id3, id4)
                                        .withTypes(AdExtensionTypeEnum.CALLOUT)
                        )
                        .withPage(
                                new LimitOffsetMap()
                                        .withOffset(2L)
                        )
        );

        List<Long> ids =
                getResponse.getAdExtensions().stream().map(AdExtensionGetItem::getId).collect(Collectors.toList());

        assertThat("получено два текстовых дополнения", ids, beanDiffer(Arrays.asList(id3, id4)));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("2227")
    public void zeroLimit() {
        api.userSteps.adExtensionsSteps().expectErrorOnAdExtensionsGet(
                new GetRequestMap()
                        .withFieldNames(AdExtensionFieldEnum.values())
                        .withSelectionCriteria(
                                new AdExtensionsSelectionCriteriaMap()
                                        .withTypes(AdExtensionTypeEnum.CALLOUT)
                        )
                        .withPage(
                                new LimitOffsetMap()
                                        .withLimit(0L)
                        ),
                new Api5Error(4002, Api5ErrorDetails.LIMIT_MUST_BE_MORE_THAN_0)
        );
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("2219")
    public void negativeLimit() {
        api.userSteps.adExtensionsSteps().expectErrorOnAdExtensionsGet(
                new GetRequestMap()
                        .withFieldNames(AdExtensionFieldEnum.values())
                        .withSelectionCriteria(
                                new AdExtensionsSelectionCriteriaMap()
                                        .withTypes(AdExtensionTypeEnum.CALLOUT)
                        )
                        .withPage(
                                new LimitOffsetMap()
                                        .withLimit(0L)
                        ),
                new Api5Error(4002, Api5ErrorDetails.LIMIT_MUST_BE_MORE_THAN_0)
        );
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("2220")
    public void maxLimit() {
        GetResponse getResponse = api.userSteps.adExtensionsSteps().getAdExtensions(
                new GetRequestMap()
                        .withFieldNames(AdExtensionFieldEnum.values())
                        .withSelectionCriteria(
                                new AdExtensionsSelectionCriteriaMap()
                                        .withTypes(AdExtensionTypeEnum.CALLOUT)
                        )
                        .withPage(
                                new LimitOffsetMap()
                                        .withLimit(LimitOffsetMap.LIMIT_MAX_LENGTH)
                        )
        );

        assertThat("получены текстовые дополнения", getResponse.getAdExtensions(), hasSize(greaterThan(0)));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("2229")
    public void overMaxLimit() {
        api.userSteps.adExtensionsSteps().expectErrorOnAdExtensionsGet(
                new GetRequestMap()
                        .withFieldNames(AdExtensionFieldEnum.values())
                        .withSelectionCriteria(
                                new AdExtensionsSelectionCriteriaMap()
                                        .withTypes(AdExtensionTypeEnum.CALLOUT)
                        )
                        .withPage(
                                new LimitOffsetMap()
                                        .withLimit(LimitOffsetMap.LIMIT_MAX_LENGTH + 1)
                        ),
                new Api5Error(4002, Api5ErrorDetails.LIMIT_CANNOT_BE_MORE, LimitOffsetMap.LIMIT_MAX_LENGTH)
        );
    }


    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("2228")
    public void checkLimitedByIfLimitNotWorked() {
        GetResponse getResponse = api.userSteps.adExtensionsSteps().getAdExtensions(
                new GetRequestMap()
                        .withFieldNames(AdExtensionFieldEnum.values())
                        .withSelectionCriteria(
                                new AdExtensionsSelectionCriteriaMap()
                                        .withIds(id1, id2, id3, id4)
                                        .withTypes(AdExtensionTypeEnum.CALLOUT)
                        )
                        .withPage(
                                new LimitOffsetMap()
                                        .withLimit(4L)
                        )
        );

        assertThat("значение LimitedBy равно", getResponse.getLimitedBy(), nullValue());
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("2230")
    public void negativeOffset() {
        api.userSteps.adExtensionsSteps().expectErrorOnAdExtensionsGet(
                new GetRequestMap()
                        .withFieldNames(AdExtensionFieldEnum.values())
                        .withSelectionCriteria(
                                new AdExtensionsSelectionCriteriaMap()
                                        .withTypes(AdExtensionTypeEnum.CALLOUT)
                        )
                        .withPage(
                                new LimitOffsetMap()
                                        .withOffset(-1L)
                        ),
                new Api5Error(4002, Api5ErrorDetails.OFFSET_MUST_BE_MORE_OR_EQUAL_THAN_0)
        );
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("2231")
    public void checkLimitedByIfLimitWorked() {
        GetResponse getResponse = api.userSteps.adExtensionsSteps().getAdExtensions(
                new GetRequestMap()
                        .withFieldNames(AdExtensionFieldEnum.values())
                        .withSelectionCriteria(
                                new AdExtensionsSelectionCriteriaMap()
                                        .withTypes(AdExtensionTypeEnum.CALLOUT)
                        )
                        .withPage(
                                new LimitOffsetMap()
                                        .withLimit(2L)
                        )
        );
        assertThat("значение LimitedBy верно", getResponse.getLimitedBy(), equalTo(2L));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("2232")
    public void checkLimitedByIfLimitWorkedWithOffset() {
        GetResponse getResponse = api.userSteps.adExtensionsSteps().getAdExtensions(
                new GetRequestMap()
                        .withFieldNames(AdExtensionFieldEnum.values())
                        .withSelectionCriteria(
                                new AdExtensionsSelectionCriteriaMap()
                                        .withTypes(AdExtensionTypeEnum.CALLOUT)
                        )
                        .withPage(
                                new LimitOffsetMap()
                                        .withOffset(1L)
                                        .withLimit(2L)
                        )
        );
        assertThat("значение LimitedBy верно", getResponse.getLimitedBy(), equalTo(3L));
    }

}
