package ru.yandex.autotests.direct.api.adextensions.get;

import com.yandex.direct.api.v5.adextensions.AdExtensionFieldEnum;
import com.yandex.direct.api.v5.adextensions.GetResponse;
import org.apache.commons.lang.RandomStringUtils;
import org.junit.*;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.adextensions.AdExtensionsFeatures;
import ru.yandex.autotests.direct.api.adextensions.AdExtensionsLogins;
import ru.yandex.autotests.direct.utils.model.ShardNumbers;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.api5.adextensions.AdExtensionGetItemMap;
import ru.yandex.autotests.directapi.model.api5.adextensions.AdExtensionsSelectionCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.adextensions.GetRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;
import ru.yandex.qatools.allure.annotations.TestCaseId;

import java.util.Arrays;
import java.util.Collection;

import static org.hamcrest.Matchers.hasSize;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.beandiffer.BeanDifferMatcher.beanDiffer;

/**
 * Created by pavryabov on 24.03.16.
 * https://st.yandex-team.ru/TESTIRT-8603
 */
@Aqua.Test
@Description("Проверка прав доступа агентства к уточнениям")
@Issue("https://st.yandex-team.ru/DIRECT-50724")
@Features(AdExtensionsFeatures.GET)
@RunWith(Parameterized.class)
public class AgencyCheckRightsToAdExtensionsTest {

    @ClassRule
    public static ApiSteps api = new ApiSteps();

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private static String client = AdExtensionsLogins.AD_EXTENSIONS_CLIENT;
    private static String agency = AdExtensionsLogins.AGENCY;
    private static String agencyRep = AdExtensionsLogins.AGENCY_REP;
    private static String agencyRepCl = AdExtensionsLogins.AGENCY_REP_CL;
    private static String subclient = AdExtensionsLogins.SUBCLIENT;
    private static String subclientElse = AdExtensionsLogins.SUBCLIENT_ELSE;

    Long clientId;
    Long subclientId;
    Long subclientElseId;

    @Parameterized.Parameter(0)
    public String loginForAuthorization;

    @Parameterized.Parameters(name = "loginForAuthorization = {0}")
    public static Collection testData() {
        Object[][] data = new Object[][]{
                {agency},
                {agencyRep},
                {agencyRepCl}
        };
        return Arrays.asList(data);
    }

    @BeforeClass
    public static void createAds() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(client);
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(agency);
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(subclient);
        api.userSteps.clientFakeSteps().reshardUserWithLock(subclient, ShardNumbers.DEFAULT_SHARD);
        api.userSteps.clientFakeSteps().reshardUserWithLock(subclientElse, ShardNumbers.DEFAULT_SHARD);
    }

    @Before
    public void deleteAds() {
        api.as(client);
        clientId = api.userSteps.adExtensionsSteps().addCalloutWithText(RandomStringUtils.randomAlphabetic(8));
        api.as(agency);
        subclientId = api.userSteps.adExtensionsSteps().addCalloutWithText(RandomStringUtils.randomAlphabetic(8), subclient);
        subclientElseId = api.userSteps.adExtensionsSteps().addCalloutWithText(RandomStringUtils.randomAlphabetic(8), subclientElse);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("2233")
    public void callGetWithSubclientAdId() {
        GetResponse getResponse = api.as(loginForAuthorization).userSteps.adExtensionsSteps().getAdExtensions(
                new GetRequestMap()
                        .withSelectionCriteria(new AdExtensionsSelectionCriteriaMap().withIds(subclientId))
                        .withFieldNames(AdExtensionFieldEnum.ID),
                subclient
        );
        assertThat("вернулось правильное уточнение", getResponse.getAdExtensions(), beanDiffer(
                Arrays.asList(new AdExtensionGetItemMap().withId(subclientId).getBean())));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("2234")
    public void callGetWithSubclientElseAdId() {
        GetResponse getResponse = api.as(loginForAuthorization).userSteps.adExtensionsSteps().getAdExtensions(
                new GetRequestMap()
                        .withSelectionCriteria(new AdExtensionsSelectionCriteriaMap().withIds(subclientElseId))
                        .withFieldNames(AdExtensionFieldEnum.ID),
                subclient
        );
        assertThat("не вернулось ни одного уточнения", getResponse.getAdExtensions(), hasSize(0));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("2235")
    public void callGetWithAdIdsOfBothSubclients() {
        GetResponse getResponse = api.as(loginForAuthorization).userSteps.adExtensionsSteps().getAdExtensions(
                new GetRequestMap()
                        .withSelectionCriteria(new AdExtensionsSelectionCriteriaMap().withIds(subclientId, subclientElseId))
                        .withFieldNames(AdExtensionFieldEnum.ID),
                subclient
        );
        assertThat("вернулось правильное уточнение", getResponse.getAdExtensions(), beanDiffer(
                Arrays.asList(new AdExtensionGetItemMap().withId(subclientId).getBean())));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("2236")
    public void callGetWithClientAdId() {
        GetResponse getResponse = api.as(loginForAuthorization).userSteps.adExtensionsSteps().getAdExtensions(
                new GetRequestMap()
                        .withSelectionCriteria(new AdExtensionsSelectionCriteriaMap().withIds(clientId))
                        .withFieldNames(AdExtensionFieldEnum.ID),
                subclient
        );
        assertThat("не вернулось ни одного уточнения", getResponse.getAdExtensions(), hasSize(0));
    }
}
