package ru.yandex.autotests.direct.api.adextensions.get;

import com.yandex.direct.api.v5.adextensions.AdExtensionFieldEnum;
import com.yandex.direct.api.v5.adextensions.GetResponse;
import org.apache.commons.lang.RandomStringUtils;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.adextensions.AdExtensionsFeatures;
import ru.yandex.autotests.direct.api.adextensions.AdExtensionsLogins;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.ModReasonsStatusmoderate;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.ModReasonsStatuspostmoderate;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.ModReasonsStatussending;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.ModReasonsType;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.api5.StatusClarification;
import ru.yandex.autotests.directapi.model.api5.adextensions.AdExtensionGetItemMap;
import ru.yandex.autotests.directapi.model.api5.adextensions.AdExtensionsSelectionCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.adextensions.GetRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static java.util.Collections.singletonList;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.beandiffer2.BeanDifferMatcher.beanDiffer;

/**
 * Created by proxeter on 17.02.16.
 * <p>
 * https://st.yandex-team.ru/TESTIRT-8603
 */
@Aqua.Test
@Description("Проверка получения текстового дополнения по типу")
@Issue("https://st.yandex-team.ru/DIRECT-50724")
@Features(AdExtensionsFeatures.GET)
public class GetAdExtensionByStatusClarificationTest {

    private static final String LOGIN = AdExtensionsLogins.AD_EXTENSIONS_STATUS_CLARIFICATION;

    private static final String TIME_CREATED = "2000-01-01 00:00:00";

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);

    @Rule
    public Trashman trashman = new Trashman(api);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    private Long id;

    @Before
    public void before() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);
        int shardId = api.userSteps.clientFakeSteps().getUserShard(LOGIN);

        id = api.userSteps.adExtensionsSteps().addCalloutWithText(RandomStringUtils.randomAlphabetic(8));

        api.userSteps.getDirectJooqDbSteps().useShard(shardId).modReasonsSteps().addModReason(
                id, ModReasonsType.callout, ModReasonsStatussending.No, ModReasonsStatusmoderate.No,
                ModReasonsStatuspostmoderate.No, TIME_CREATED, singletonList(166));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("2239")
    public void getAdExtensionByType() {
        GetResponse getResponse = api.userSteps.adExtensionsSteps().getAdExtensions(
                new GetRequestMap()
                        .withFieldNames(AdExtensionFieldEnum.ID, AdExtensionFieldEnum.STATUS_CLARIFICATION)
                        .withSelectionCriteria(
                                new AdExtensionsSelectionCriteriaMap()
                                        .withIds(id)
                        )
        );
        assertThat(
                "получен элемент с правильным statusClarification",
                getResponse.getAdExtensions(),
                beanDiffer(singletonList(
                        new AdExtensionGetItemMap()
                                .withId(id)
                                .withStatusClarification(StatusClarification.CALLOUT_DOESNT_ADHERE_TO_ADV_POLICY_JAVA
                                        .getStatusClarification())
                                .getBean()
                ))
        );
    }

}
