package ru.yandex.autotests.direct.api.adextensions.get;

import com.yandex.direct.api.v5.adextensions.AdExtensionFieldEnum;
import com.yandex.direct.api.v5.adextensions.AdExtensionGetItem;
import com.yandex.direct.api.v5.adextensions.AddResponse;
import com.yandex.direct.api.v5.adextensions.GetResponse;
import com.yandex.direct.api.v5.general.ExtensionStatusSelectionEnum;
import com.yandex.direct.api.v5.general.StatusEnum;
import org.apache.commons.lang.RandomStringUtils;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.adextensions.AdExtensionsFeatures;
import ru.yandex.autotests.direct.api.adextensions.AdExtensionsLogins;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.AdditionsItemCalloutsStatusmoderate;
import ru.yandex.autotests.direct.db.steps.DirectJooqDbSteps;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.api5.adextensions.AdExtensionAddItemMap;
import ru.yandex.autotests.directapi.model.api5.adextensions.AdExtensionsSelectionCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.adextensions.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.adextensions.GetRequestMap;
import ru.yandex.autotests.directapi.model.api5.adextensiontypes.CalloutMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;

import static org.hamcrest.Matchers.greaterThan;
import static org.hamcrest.Matchers.hasSize;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.beandiffer2.BeanDifferMatcher.beanDiffer;

/**
 * Created by proxeter on 17.02.16.
 * <p>
 * https://st.yandex-team.ru/TESTIRT-8603
 */
@Aqua.Test
@Description("Проверка получения текстового дополнения по статусу")
@Issue("https://st.yandex-team.ru/DIRECT-50724")
@Features(AdExtensionsFeatures.GET)
@RunWith(Parameterized.class)
public class GetAdExtensionByStatusTest {

    private static final String LOGIN = AdExtensionsLogins.AD_EXTENSIONS_CLIENT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);
    private static DirectJooqDbSteps jooqDbSteps;

    @Rule
    public Trashman trashman = new Trashman(api);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    private Long id;

    @Parameterized.Parameter(value = 0)
    public AdditionsItemCalloutsStatusmoderate statusModerate;

    @Parameterized.Parameter(value = 1)
    public ExtensionStatusSelectionEnum statusEnum;

    @Parameterized.Parameters(name = "dbStatus = {0}, apiStatus = {1}")
    public static Collection testData() {
        Object[][] data = new Object[][]{
                {AdditionsItemCalloutsStatusmoderate.New, ExtensionStatusSelectionEnum.DRAFT},
                {AdditionsItemCalloutsStatusmoderate.Sent, ExtensionStatusSelectionEnum.MODERATION},
                {AdditionsItemCalloutsStatusmoderate.Sending, ExtensionStatusSelectionEnum.MODERATION},
                {AdditionsItemCalloutsStatusmoderate.Ready, ExtensionStatusSelectionEnum.MODERATION},
                {AdditionsItemCalloutsStatusmoderate.Yes, ExtensionStatusSelectionEnum.ACCEPTED},
                {AdditionsItemCalloutsStatusmoderate.No, ExtensionStatusSelectionEnum.REJECTED}
        };
        return Arrays.asList(data);
    }

    @Before
    public void before() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);
        jooqDbSteps = api.userSteps.getDirectJooqDbSteps().useShardForLogin(LOGIN);

        AddResponse addResponse = api.userSteps.adExtensionsSteps().shouldGetResultOnAdExtensionsAdd(
                new AddRequestMap().withAdExtensions(
                        new AdExtensionAddItemMap()
                                .withCallout(
                                        new CalloutMap().withCalloutText(RandomStringUtils.random(8, true, false))
                                )
                ),
                ExpectedResult.success()
        );

        id = addResponse.getAddResults().get(0).getId();

        jooqDbSteps.bannerAdditionsSteps().setAdditionsItemCalloutsStatusModerated(id, statusModerate);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("2240")
    public void getAdExtensionByType() {
        GetResponse getResponse = api.userSteps.adExtensionsSteps().getAdExtensions(
                new GetRequestMap()
                        .withFieldNames(AdExtensionFieldEnum.values())
                        .withSelectionCriteria(
                                new AdExtensionsSelectionCriteriaMap()
                                        .withIds(id)
                                        .withStatuses(statusEnum)
                        )
        );
        assertThat("найдено хотя бы одно текстовое дополнение", getResponse.getAdExtensions(), hasSize(greaterThan(0)));

        List<AdExtensionGetItem> types =
                getResponse.getAdExtensions()
                        .stream()
                        .filter(adExtension -> adExtension.getStatus() == StatusEnum.fromValue(statusEnum.value()))
                        .collect(Collectors.toList());

        assertThat("найдены правильные текстовые дополнения по типу", getResponse.getAdExtensions(), beanDiffer(types));
    }

}
