package ru.yandex.autotests.direct.api.adextensions.get;

import com.yandex.direct.api.v5.adextensions.AdExtensionFieldEnum;
import com.yandex.direct.api.v5.adextensions.AddResponse;
import com.yandex.direct.api.v5.adextensiontypes.AdExtensionTypeEnum;
import org.apache.commons.lang.RandomStringUtils;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.adextensions.AdExtensionsFeatures;
import ru.yandex.autotests.direct.api.adextensions.AdExtensionsLogins;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5Error;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetailsJava;
import ru.yandex.autotests.directapi.model.api5.adextensions.AdExtensionAddItemMap;
import ru.yandex.autotests.directapi.model.api5.adextensions.AdExtensionsSelectionCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.adextensions.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.adextensions.GetRequestMap;
import ru.yandex.autotests.directapi.model.api5.adextensiontypes.CalloutMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.equalTo;
import static ru.yandex.autotests.directapi.apiclient.errors.Path.path;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

/**
 * Created by proxeter on 25.02.16.
 * <p>
 * https://st.yandex-team.ru/TESTIRT-8603
 */
@Aqua.Test
@Description("Проверка списания баллов при получении текстового дополнения")
@Issue("https://st.yandex-team.ru/DIRECT-50724")
@Features(AdExtensionsFeatures.GET)
public class GetAdExtensionUnitsTest {

    private static final String LOGIN = AdExtensionsLogins.UNITS_GET_LOGIN;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);

    @Rule
    public Trashman trashman = new Trashman(api);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    private Long id1;
    private Long id2;

    @Before
    public void before() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);

        AddResponse addResponse = api.userSteps.adExtensionsSteps().shouldGetResultOnAdExtensionsAdd(
                new AddRequestMap().withAdExtensions(
                        new AdExtensionAddItemMap()
                                .withCallout(
                                        new CalloutMap().withCalloutText(RandomStringUtils.random(8, true, false))
                                ),
                        new AdExtensionAddItemMap()
                                .withCallout(
                                        new CalloutMap().withCalloutText(RandomStringUtils.random(8, true, false))
                                )
                ),
                ExpectedResult.success(),
                ExpectedResult.success()
        );

        id1 = addResponse.getAddResults().get(0).getId();
        id2 = addResponse.getAddResults().get(1).getId();
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("2244")
    public void getAdExtensionUnits() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);

        int unitsBefore = api.userSteps.clientFakeSteps().fakeClientUnitsBalance(LOGIN);
        api.userSteps.adExtensionsSteps().getAdExtensions(
                new GetRequestMap()
                        .withFieldNames(AdExtensionFieldEnum.values())
                        .withSelectionCriteria(
                                new AdExtensionsSelectionCriteriaMap().withIds(id1)
                        )
        );
        int unitsAfter = api.userSteps.clientFakeSteps().fakeClientUnitsBalance(LOGIN);

        Integer cost = GetRequestMap.GET_UNITS_COST + (1 * GetRequestMap.GET_OBJECT_COST); // 1 объект
        assertThat("списалось правильное количество баллов", unitsAfter, equalTo(unitsBefore - cost));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("2245")
    public void getTwoAdExtensionUnits() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);

        int unitsBefore = api.userSteps.clientFakeSteps().fakeClientUnitsBalance(LOGIN);
        api.userSteps.adExtensionsSteps().getAdExtensions(
                new GetRequestMap()
                        .withFieldNames(AdExtensionFieldEnum.values())
                        .withSelectionCriteria(
                                new AdExtensionsSelectionCriteriaMap().withIds(id1, id2)
                        )
        );
        int unitsAfter = api.userSteps.clientFakeSteps().fakeClientUnitsBalance(LOGIN);

        Integer cost = GetRequestMap.GET_UNITS_COST + (2 * GetRequestMap.GET_OBJECT_COST); // 2 объекта
        assertThat("списалось правильное количество баллов", unitsAfter, equalTo(unitsBefore - cost));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("2246")
    public void getAdExtensionInvalidWsdlUnits() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);

        int unitsBefore = api.userSteps.clientFakeSteps().fakeClientUnitsBalance(LOGIN);
        api.userSteps.adExtensionsSteps().expectErrorOnAdExtensionsGet(
                new GetRequestMap()
                        .withFieldNames("invalid_value")
                        .withSelectionCriteria(
                                new AdExtensionsSelectionCriteriaMap()
                                        .withTypes(AdExtensionTypeEnum.CALLOUT)
                        ),
                new Api5Error(
                        8000,
                        Api5ErrorDetailsJava.ELEMENT_OF_ARRAY_CONTAINS_INCORRECT_ENUMERATE_VALUE,
                        path(GetRequestMap.FIELD_NAMES),
                        Api5Error.enumAsParam(AdExtensionFieldEnum.class)
                )
        );
        int unitsAfter = api.userSteps.clientFakeSteps().fakeClientUnitsBalance(LOGIN);

        Integer cost = GetRequestMap.GET_INVALID_WSDL_COST;
        assertThat("списалось правильное количество баллов", unitsAfter, equalTo(unitsBefore - cost));
    }

}
