package ru.yandex.autotests.direct.api.adextensions.get;

import com.yandex.direct.api.v5.adextensions.AdExtensionFieldEnum;
import com.yandex.direct.api.v5.adextensions.AdExtensionGetItem;
import com.yandex.direct.api.v5.adextensions.AddResponse;
import com.yandex.direct.api.v5.adextensions.GetResponse;
import com.yandex.direct.api.v5.adextensiontypes.AdExtensionStateSelectionEnum;
import com.yandex.direct.api.v5.adextensiontypes.AdExtensionTypeEnum;
import com.yandex.direct.api.v5.general.ExtensionStatusSelectionEnum;
import com.yandex.direct.api.v5.general.StateEnum;
import com.yandex.direct.api.v5.general.StatusEnum;
import org.apache.commons.lang.RandomStringUtils;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.adextensions.AdExtensionsFeatures;
import ru.yandex.autotests.direct.api.adextensions.AdExtensionsLogins;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.AdditionsItemCalloutsStatusmoderate;
import ru.yandex.autotests.direct.db.steps.DirectJooqDbSteps;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.api5.adextensions.*;
import ru.yandex.autotests.directapi.model.api5.adextensiontypes.CalloutMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import java.util.Arrays;

import static org.hamcrest.MatcherAssert.assertThat;
import static ru.yandex.autotests.irt.testutils.beandiffer2.BeanDifferMatcher.beanDiffer;

/**
 * Created by proxeter on 17.02.16.
 * <p>
 * https://st.yandex-team.ru/TESTIRT-8603
 */
@Aqua.Test
@Description("Проверка получения текстового дополнения с несколькими параметрами selection criteria")
@Issue("https://st.yandex-team.ru/DIRECT-50724")
@Features(AdExtensionsFeatures.GET)
public class GetAdExtensionWithMultipleSelectionCriteriaTest {

    private static final String LOGIN = AdExtensionsLogins.AD_EXTENSIONS_CLIENT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);
    private static DirectJooqDbSteps jooqDbSteps;

    @Rule
    public Trashman trashman = new Trashman(api);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    private Long id;

    private String calloutText = RandomStringUtils.random(8, true, false);

    @Before
    public void before() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);
        jooqDbSteps = api.userSteps.getDirectJooqDbSteps().useShardForLogin(LOGIN);

        AddResponse addResponse = api.userSteps.adExtensionsSteps().shouldGetResultOnAdExtensionsAdd(
                new AddRequestMap().withAdExtensions(
                        new AdExtensionAddItemMap()
                                .withCallout(
                                        new CalloutMap().withCalloutText(calloutText)
                                )
                ),
                ExpectedResult.success()
        );

        id = addResponse.getAddResults().get(0).getId();
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("2248")
    public void getAdExtensionWithIdAndTypeInSelectionCriteria() {
        GetResponse getResponse = api.userSteps.adExtensionsSteps().getAdExtensions(
                new GetRequestMap()
                        .withFieldNames(AdExtensionFieldEnum.ID, AdExtensionFieldEnum.TYPE)
                        .withSelectionCriteria(
                                new AdExtensionsSelectionCriteriaMap()
                                        .withIds(id)
                                        .withTypes(AdExtensionTypeEnum.CALLOUT)
                        )
        );

        AdExtensionGetItem expectedItem =
                (AdExtensionGetItem) new AdExtensionGetItemMap()
                        .withId(id)
                        .withType(AdExtensionTypeEnum.CALLOUT).getBean();

        assertThat(
                "получен объект с запрошенными данными",
                getResponse.getAdExtensions(),
                beanDiffer(
                        Arrays.asList(
                                expectedItem
                        )
                )
        );
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("2249")
    public void getAdExtensionWithIdAndStatusInSelectionCriteria() {
        GetResponse getResponse = api.userSteps.adExtensionsSteps().getAdExtensions(
                new GetRequestMap()
                        .withFieldNames(AdExtensionFieldEnum.ID, AdExtensionFieldEnum.STATUS)
                        .withSelectionCriteria(
                                new AdExtensionsSelectionCriteriaMap()
                                        .withIds(id)
                                        .withStatuses(ExtensionStatusSelectionEnum.MODERATION)
                        )
        );

        AdExtensionGetItem expectedItem =
                (AdExtensionGetItem) new AdExtensionGetItemMap()
                        .withId(id)
                        .withStatus(StatusEnum.MODERATION).getBean();

        assertThat(
                "получен объект с запрошенными данными",
                getResponse.getAdExtensions(),
                beanDiffer(
                        Arrays.asList(
                                expectedItem
                        )
                )
        );
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("2250")
    public void getAdExtensionWithIdAndStateInSelectionCriteria() {
        GetResponse getResponse = api.userSteps.adExtensionsSteps().getAdExtensions(
                new GetRequestMap()
                        .withFieldNames(AdExtensionFieldEnum.ID, AdExtensionFieldEnum.STATE)
                        .withSelectionCriteria(
                                new AdExtensionsSelectionCriteriaMap()
                                        .withIds(id)
                                        .withStates(AdExtensionStateSelectionEnum.ON)
                        )
        );

        AdExtensionGetItem expectedItem =
                (AdExtensionGetItem) new AdExtensionGetItemMap()
                        .withId(id)
                        .withState(StateEnum.ON).getBean();

        assertThat(
                "получен объект с запрошенными данными",
                getResponse.getAdExtensions(),
                beanDiffer(
                        Arrays.asList(
                                expectedItem
                        )
                )
        );
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("2251")
    public void getAdExtensionWithAllFieldsInSelectionCriteria() {
        GetResponse getResponse = api.userSteps.adExtensionsSteps().getAdExtensions(
                new GetRequestMap()
                        .withFieldNames(
                                AdExtensionFieldEnum.ID,
                                AdExtensionFieldEnum.TYPE,
                                AdExtensionFieldEnum.STATUS,
                                AdExtensionFieldEnum.STATE
                        )
                        .withSelectionCriteria(
                                new AdExtensionsSelectionCriteriaMap()
                                        .withIds(id)
                                        .withTypes(AdExtensionTypeEnum.CALLOUT)
                                        .withStatuses(ExtensionStatusSelectionEnum.MODERATION)
                                        .withStates(AdExtensionStateSelectionEnum.ON)
                        )
        );

        AdExtensionGetItem expectedItem =
                (AdExtensionGetItem) new AdExtensionGetItemMap()
                        .withId(id)
                        .withType(AdExtensionTypeEnum.CALLOUT)
                        .withStatus(StatusEnum.MODERATION)
                        .withState(StateEnum.ON).getBean();

        assertThat(
                "получен объект с запрошенными данными",
                getResponse.getAdExtensions(),
                beanDiffer(
                        Arrays.asList(
                                expectedItem
                        )
                )
        );
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("2252")
    public void getAdExtensionWithAllFieldsAndRealSortInSelectionCriteria() {
        jooqDbSteps.bannerAdditionsSteps().setAdditionsItemCalloutsStatusModerated(id, AdditionsItemCalloutsStatusmoderate.No);

        GetResponse getResponse = api.userSteps.adExtensionsSteps().getAdExtensions(
                new GetRequestMap()
                        .withFieldNames(
                                AdExtensionFieldEnum.ID,
                                AdExtensionFieldEnum.TYPE,
                                AdExtensionFieldEnum.STATUS,
                                AdExtensionFieldEnum.STATE)
                        .withSelectionCriteria(
                                new AdExtensionsSelectionCriteriaMap()
                                        .withIds(id)
                                        .withTypes(AdExtensionTypeEnum.CALLOUT)
                                        .withStatuses(ExtensionStatusSelectionEnum.REJECTED)
                                        .withStates(AdExtensionStateSelectionEnum.ON)
                        )
        );

        AdExtensionGetItem expectedItem =
                (AdExtensionGetItem) new AdExtensionGetItemMap()
                        .withId(id)
                        .withType(AdExtensionTypeEnum.CALLOUT)
                        .withStatus(StatusEnum.REJECTED)
                        .withState(StateEnum.ON).getBean();

        assertThat(
                "получен объект с запрошенными данными",
                getResponse.getAdExtensions(),
                beanDiffer(
                        Arrays.asList(
                                expectedItem
                        )
                )
        );
    }

}
