package ru.yandex.autotests.direct.api.adextensions.get;

import java.util.Collections;

import com.yandex.direct.api.v5.adextensions.AdExtensionFieldEnum;
import com.yandex.direct.api.v5.adextensions.AdExtensionGetItem;
import com.yandex.direct.api.v5.adextensions.GetResponse;
import org.apache.commons.lang.RandomStringUtils;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.adextensions.AdExtensionsFeatures;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.common.api45mng.APIPort_PortType;
import ru.yandex.autotests.directapi.model.Logins;
import ru.yandex.autotests.directapi.model.User;
import ru.yandex.autotests.directapi.model.api5.adextensions.AdExtensionGetItemMap;
import ru.yandex.autotests.directapi.model.api5.adextensions.AdExtensionsSelectionCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.adextensions.GetRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.hasSize;
import static ru.yandex.autotests.directapi.matchers.beans.version5.BeanDifferMatcherV5.beanDifferV5;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

/**
 * Created by ginger on 08.12.16.
 * https://st.yandex-team.ru/TESTIRT-10642
 */
@Aqua.Test
@Description("Проверка корректности работы метода при наличии дисклеймера у клиента")
@Issue("https://st.yandex-team.ru/DIRECT-59010")
@Features(AdExtensionsFeatures.GET)
public class GetAdExtensionsDisclaimerTest {
    private static Long disclaimerId;
    private static int shardId;
    private static Long adExtensionId;
    private static final String LOGIN = Logins.LOGIN_FOR_USD;

    @ClassRule
    public static final ApiSteps api = new ApiSteps();

    @ClassRule
    public static final SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);


    @BeforeClass
    public static void prepareData() {
        String manager = Logins.MANAGER_DEFAULT;
        api.as(manager).wsdl(APIPort_PortType.class);
        shardId = api.userSteps.clientFakeSteps().getUserShard(LOGIN);
        disclaimerId = api.userSteps.getDirectJooqDbSteps().useShard(shardId)
                .bannerAdditionsSteps().saveAdditionsItemDisclaimers(
                                Long.parseLong(User.get(LOGIN).getClientID()),
                                RandomStringUtils.randomAlphanumeric(24));
        adExtensionId = api.userSteps.adExtensionsSteps().addCalloutWithText(RandomStringUtils.randomAlphabetic(8), LOGIN);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("2644")
    public void getWithEmptySelectionCriteria() {
        GetResponse getResponse = api.userSteps.adExtensionsSteps().getAdExtensions(
                new GetRequestMap()
                        .withFieldNames(AdExtensionFieldEnum.ID)
                        .withSelectionCriteria(new AdExtensionsSelectionCriteriaMap()),
                LOGIN
        );
        assertThat("вернулся правильный ответ", getResponse.getAdExtensions(), beanDifferV5(
                Collections.singletonList(
                        new AdExtensionGetItemMap().withId(adExtensionId).getBean())));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("2645")
    public void getWithDisclaimerIdInSelectionCriteria() {
        GetResponse getResponse = api.userSteps.adExtensionsSteps().getAdExtensions(
                new GetRequestMap()
                        .withFieldNames(AdExtensionFieldEnum.ID)
                        .withSelectionCriteria(
                                new AdExtensionsSelectionCriteriaMap()
                                    .withIds(disclaimerId)
                        ),
                LOGIN
        );
        assertThat("вернулся правильный ответ", getResponse.getAdExtensions(), hasSize(0));
    }

    @AfterClass
    public static void deleteDisclaimer(){
        api.userSteps.getDirectJooqDbSteps().useShard(shardId)
                .bannerAdditionsSteps().deleteAdditionsItemDisclaimers(disclaimerId);
        // и удалим мусор ещё
        GetResponse getResponse = api.userSteps.adExtensionsSteps().getAdExtensions(
                new GetRequestMap()
                        .withFieldNames(AdExtensionFieldEnum.ID)
                        .withSelectionCriteria(new AdExtensionsSelectionCriteriaMap()),
                LOGIN
        );
        api.userSteps.adExtensionsSteps().adExtensionsDelete(LOGIN,
                getResponse.getAdExtensions().stream().map(AdExtensionGetItem::getId).toArray(Long[]::new)
        );
    }
}
