package ru.yandex.autotests.direct.api.adextensions.get;

import com.yandex.direct.api.v5.adextensions.AdExtensionFieldEnum;
import com.yandex.direct.api.v5.adextensions.AdExtensionGetItem;
import com.yandex.direct.api.v5.adextensions.AddResponse;
import com.yandex.direct.api.v5.adextensions.GetResponse;
import com.yandex.direct.api.v5.adextensiontypes.AdExtensionTypeEnum;
import com.yandex.direct.api.v5.general.StateEnum;
import com.yandex.direct.api.v5.general.StatusEnum;
import com.yandex.direct.api.v5.general.YesNoEnum;
import org.apache.commons.lang.RandomStringUtils;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.adextensions.AdExtensionsFeatures;
import ru.yandex.autotests.direct.api.adextensions.AdExtensionsLogins;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.api5.adextensions.*;
import ru.yandex.autotests.directapi.model.api5.adextensiontypes.CalloutMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;
import ru.yandex.qatools.allure.annotations.TestCaseId;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;

import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.beandiffer2.BeanDifferMatcher.beanDiffer;

/**
 * Created by proxeter on 17.02.16.
 * <p>
 * https://st.yandex-team.ru/TESTIRT-8603
 */
@Aqua.Test
@Description("Проверка получения полей текстового дополнения")
@Issue("https://st.yandex-team.ru/DIRECT-50724")
@Features(AdExtensionsFeatures.GET)
@RunWith(Parameterized.class)
public class GetAdExtensionsFieldsTest {

    private static final String LOGIN = AdExtensionsLogins.AD_EXTENSIONS_CLIENT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);

    @Rule
    public Trashman trashman = new Trashman(api);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Parameterized.Parameter(value = 0)
    public AdExtensionFieldEnum field;

    @Parameterized.Parameter(value = 1)
    public AdExtensionGetItemMap getItem;

    @Parameterized.Parameters(name = "selectionCriteria = {0}, getItem = {1}")
    public static Collection testData() {
        Object[][] data = new Object[][]{
                {
                        AdExtensionFieldEnum.ID,
                        null
                },
                {
                        AdExtensionFieldEnum.TYPE,
                        new AdExtensionGetItemMap().withType(AdExtensionTypeEnum.CALLOUT)
                },
                {
                        AdExtensionFieldEnum.STATUS,
                        new AdExtensionGetItemMap().withStatus(StatusEnum.MODERATION)
                },
                {
                        AdExtensionFieldEnum.STATE,
                        new AdExtensionGetItemMap().withState(StateEnum.ON)
                },
                {
                        AdExtensionFieldEnum.ASSOCIATED,
                        new AdExtensionGetItemMap().withAssociated(YesNoEnum.NO)
                },
                {
                        AdExtensionFieldEnum.STATUS_CLARIFICATION,
                        new AdExtensionGetItemMap().withStatusClarification("")
                }

        };
        return Arrays.asList(data);
    }

    private static Long id;

    @BeforeClass
    public static void beforeClass() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);

        AddResponse addResponse = api.userSteps.adExtensionsSteps().shouldGetResultOnAdExtensionsAdd(
                new AddRequestMap().withAdExtensions(
                        new AdExtensionAddItemMap()
                                .withCallout(
                                        new CalloutMap().withCalloutText(RandomStringUtils.random(8, true, false))
                                )
                ),
                ExpectedResult.success()
        );

        id = addResponse.getAddResults().get(0).getId();
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("2254")
    public void getAdExtensionFields() {
        GetResponse adExtensions = api.userSteps.adExtensionsSteps().getAdExtensions(
                new GetRequestMap()
                        .withFieldNames(field)
                        .withSelectionCriteria(
                                new AdExtensionsSelectionCriteriaMap().withIds(id)
                        )
        );

        // id формируется позже чем инициализируются значения
        if (field == AdExtensionFieldEnum.ID) {
            getItem = new AdExtensionGetItemMap().withId(id);
        }
        AdExtensionGetItem expectedAdExtension = (AdExtensionGetItem) getItem.getBean();

        assertThat(
                "найдено правильное текстовое дополнение",
                adExtensions.getAdExtensions(),
                beanDiffer(
                        Collections.singletonList(
                                expectedAdExtension
                        )
                )
        );
    }

}
