package ru.yandex.autotests.direct.api.adextensions.get;

import java.util.stream.Stream;

import com.yandex.direct.api.v5.adextensions.AdExtensionFieldEnum;
import com.yandex.direct.api.v5.adextensions.CalloutFieldEnum;
import org.json.simple.JSONObject;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.adextensions.AdExtensionsFeatures;
import ru.yandex.autotests.direct.api.adextensions.AdExtensionsLogins;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5Error;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetailsJava;
import ru.yandex.autotests.directapi.model.api5.adextensions.AdExtensionsSelectionCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.adextensions.GetRequestMap;
import ru.yandex.autotests.directapi.model.api5.ads.AdsSelectionCriteriaMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static java.util.stream.Collectors.joining;
import static org.apache.commons.lang3.StringUtils.capitalize;

/**
 * Created by proxeter on 16.03.16.
 * <p>
 * https://st.yandex-team.ru/TESTIRT-8603
 */
@Aqua.Test
@Description("Проверка неправильно сформированного JSON при получении текстового дополнения")
@Issue("https://st.yandex-team.ru/DIRECT-50724")
@Features(AdExtensionsFeatures.GET)
public class GetAdExtensionsInvalidJsonTest {

    private static final String LOGIN = AdExtensionsLogins.AD_EXTENSIONS_CLIENT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);

    @Rule
    public Trashman trashman = new Trashman(api);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Before
    public void before() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("2256")
    public void geAdExtensionsInvalidCalloutFieldNamesJson() {
        JSONObject request = new JSONObject();
        JSONObject selectionCriteria = new JSONObject();
        selectionCriteria.put(capitalize(AdExtensionsSelectionCriteriaMap.IDS), new Long[]{123l});
        request.put(capitalize(GetRequestMap.FIELD_NAMES), AdExtensionFieldEnum.ID);
        request.put(capitalize(GetRequestMap.CALLOUT_FIELD_NAMES), new Object[]{CalloutFieldEnum.CALLOUT_TEXT});
        request.put(capitalize(GetRequestMap.SELECTION_CRITERIA), selectionCriteria);
        api.userSteps.adExtensionsSteps().expectErrorOnGet(
                request,
                new Api5Error(8000, Api5ErrorDetails.FIELD_MUST_CONTAIN_ARRAY, capitalize(GetRequestMap.FIELD_NAMES))
        );
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("2255")
    public void invalidFieldInSelectionCriteria() {
        JSONObject request = new JSONObject();
        JSONObject selectionCriteria = new JSONObject();
        selectionCriteria.put(capitalize(AdExtensionsSelectionCriteriaMap.IDS), new Long[]{123l});
        selectionCriteria.put(AdExtensionsSelectionCriteriaMap.IDS, new Long[]{123l});
        request.put(capitalize(GetRequestMap.SELECTION_CRITERIA), selectionCriteria);
        request.put(capitalize(GetRequestMap.FIELD_NAMES), new Object[]{AdExtensionFieldEnum.ID});
        api.userSteps.adsSteps().expectErrorOnAdsGet(
                request,
                new Api5Error(8000, Api5ErrorDetailsJava.UNKNOWN_PARAMETER,
                        Stream.of(capitalize(GetRequestMap.SELECTION_CRITERIA), AdsSelectionCriteriaMap.IDS)
                                .collect(joining(".")))
        );
    }
}
