package ru.yandex.autotests.direct.api.adextensions.get;

import com.yandex.direct.api.v5.adextensions.*;
import com.yandex.direct.api.v5.adextensiontypes.AdExtensionTypeEnum;
import com.yandex.direct.api.v5.general.StateEnum;
import com.yandex.direct.api.v5.general.StatusEnum;
import com.yandex.direct.api.v5.general.YesNoEnum;
import org.apache.commons.lang.RandomStringUtils;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.adextensions.AdExtensionsFeatures;
import ru.yandex.autotests.direct.api.adextensions.AdExtensionsLogins;
import ru.yandex.autotests.directapi.apiclient.config.ProtocolType;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.api5.adextensions.*;
import ru.yandex.autotests.directapi.model.api5.adextensiontypes.CalloutMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;
import ru.yandex.qatools.allure.annotations.TestCaseId;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;

import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.beandiffer2.BeanDifferMatcher.beanDiffer;

/**
 * Created by proxeter on 17.02.16.
 * <p>
 * https://st.yandex-team.ru/TESTIRT-8603
 */
@Aqua.Test
@Description("Проверка получения текстового дополнения")
@Issue("https://st.yandex-team.ru/DIRECT-50724")
@Features(AdExtensionsFeatures.GET)
@RunWith(Parameterized.class)
public class GetAdExtensionsWithProtocolsTest {

    private static final String LOGIN = AdExtensionsLogins.AD_EXTENSIONS_CLIENT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);

    @Rule
    public Trashman trashman = new Trashman(api);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Parameterized.Parameter(value = 0)
    public ProtocolType protocol;

    @Parameterized.Parameters(name = "protocol = {0}")
    public static Collection data() {
        return Arrays.asList(new Object[][]{
                {ProtocolType.JSON},
                {ProtocolType.SOAP}
        });
    }

    private Long id;

    private String calloutText = RandomStringUtils.random(8, true, false);

    @Before
    public void before() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);

        AddResponse addResponse = api.userSteps.adExtensionsSteps().shouldGetResultOnAdExtensionsAdd(
                new AddRequestMap().withAdExtensions(
                        new AdExtensionAddItemMap()
                                .withCallout(
                                        new CalloutMap().withCalloutText(calloutText)
                                )
                ),
                ExpectedResult.success()
        );

        id = addResponse.getAddResults().get(0).getId();
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("2257")
    public void getAdExtension() {
        GetResponse adExtensions = api.protocol(protocol).userSteps.adExtensionsSteps().getAdExtensions(
                new GetRequestMap()
                        .withFieldNames(AdExtensionFieldEnum.values())
                        .withCalloutFieldNames(CalloutFieldEnum.CALLOUT_TEXT)
                        .withSelectionCriteria(
                                new AdExtensionsSelectionCriteriaMap().withIds(id)
                        )
        );

        AdExtensionGetItem expectedAdExtension =
                (AdExtensionGetItem) new AdExtensionGetItemMap()
                        .withId(id)
                        .withStatus(StatusEnum.MODERATION)
                        .withState(StateEnum.ON)
                        .withAssociated(YesNoEnum.NO)
                        .withStatusClarification("")
                        .withType(AdExtensionTypeEnum.CALLOUT)
                        .withCallout(new CalloutMap().withCalloutText(calloutText))
                        .getBean();

        assertThat(
                "найдено правильное текстовое дополнение",
                adExtensions.getAdExtensions(),
                beanDiffer(
                        Collections.singletonList(
                                expectedAdExtension
                        )
                )
        );
    }

}
