package ru.yandex.autotests.direct.api.adextensions.get;

import java.util.Arrays;

import com.yandex.direct.api.v5.adextensions.AdExtensionFieldEnum;
import com.yandex.direct.api.v5.adextensions.GetResponse;
import com.yandex.direct.api.v5.general.OperationEnum;
import com.yandex.direct.api.v5.general.YesNoEnum;
import org.apache.commons.lang.RandomStringUtils;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.adextensions.AdExtensionsFeatures;
import ru.yandex.autotests.direct.api.adextensions.AdExtensionsLogins;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.api5.adextensions.AdExtensionGetItemMap;
import ru.yandex.autotests.directapi.model.api5.adextensions.AdExtensionsSelectionCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.adextensions.GetRequestMap;
import ru.yandex.autotests.directapi.model.api5.adextensiontypes.AdExtensionSettingItemMap;
import ru.yandex.autotests.directapi.model.api5.adextensiontypes.AdExtensionSettingMap;
import ru.yandex.autotests.directapi.model.api5.ads.AdAddItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.AdUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.ads.TextAdAddMap;
import ru.yandex.autotests.directapi.model.api5.ads.TextAdUpdateMap;
import ru.yandex.autotests.directapi.model.api5.ads.UpdateRequestMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.beandiffer2.BeanDifferMatcher.beanDiffer;

/**
 * Created by pavryabov on 01.04.16.
 * https://st.yandex-team.ru/TESTIRT-8935
 */
@Aqua.Test
@Description("Проверка получения поля Associated")
@Issue("https://st.yandex-team.ru/DIRECT-52547")
@Features(AdExtensionsFeatures.GET)
@Tag(TagDictionary.TRUNK)
public class GetAssociatedTest {

    private static final String LOGIN = AdExtensionsLogins.AD_EXTENSIONS_CLIENT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);

    @Rule
    public Trashman trashman = new Trashman(api);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    private static Long adGroupId;

    private Long id1;

    @BeforeClass
    public static void createAdGroup() {
        Long campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign();
        adGroupId = api.userSteps.adGroupsSteps().addDefaultGroup(campaignId);
    }

    @Before
    public void before() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);

        id1 = api.userSteps.adExtensionsSteps().addCalloutWithText(RandomStringUtils.randomAlphabetic(8));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("2259")
    public void getNoLinkedAdExtension() {
        GetResponse getResponse = api.userSteps.adExtensionsSteps().getAdExtensions(
                new GetRequestMap()
                        .withFieldNames(AdExtensionFieldEnum.ID, AdExtensionFieldEnum.ASSOCIATED)
                        .withSelectionCriteria(
                                new AdExtensionsSelectionCriteriaMap()
                                        .withIds(id1)
                        )
        );
        assertThat("вернулось правиное уточнение", getResponse.getAdExtensions(),
                beanDiffer(Arrays.asList(
                        new AdExtensionGetItemMap().withId(id1).withAssociated(YesNoEnum.NO).getBean()
                )));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("2260")
    public void getAdExtensionLinkedToOneAd() {
        api.userSteps.adsSteps().shouldGetResultOnAdd(new AddRequestMap()
                        .withAds(new AdAddItemMap()
                                .withTextAd(new TextAdAddMap().defaultTextAd().withAdExtensionIds(id1))
                                .withAdGroupId(adGroupId)),
                ExpectedResult.success());

        GetResponse getResponse = api.userSteps.adExtensionsSteps().getAdExtensions(
                new GetRequestMap()
                        .withFieldNames(AdExtensionFieldEnum.ID, AdExtensionFieldEnum.ASSOCIATED)
                        .withSelectionCriteria(
                                new AdExtensionsSelectionCriteriaMap()
                                        .withIds(id1)
                        )
        );
        assertThat("вернулось правиное уточнение", getResponse.getAdExtensions(),
                beanDiffer(Arrays.asList(
                        new AdExtensionGetItemMap().withId(id1).withAssociated(YesNoEnum.YES).getBean()
                )));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("2261")
    public void getAdExtensionUnlinkedFromOneAd() {
        Long adId = api.userSteps.adsSteps().shouldGetResultOnAdd(new AddRequestMap()
                        .withAds(new AdAddItemMap()
                                .withTextAd(new TextAdAddMap().defaultTextAd().withAdExtensionIds(id1))
                                .withAdGroupId(adGroupId)),
                ExpectedResult.success()).getAddResults().get(0).getId();

        api.userSteps.adsSteps().shouldGetResultOnUpdate(new UpdateRequestMap().withAds(new AdUpdateItemMap()
                .withId(adId)
                .withTextAd(new TextAdUpdateMap()
                        .withCalloutSetting(new AdExtensionSettingMap()
                                .withAdExtensions(new AdExtensionSettingItemMap()
                                        .withOperation(OperationEnum.REMOVE)
                                        .withAdExtensionId(id1))))), ExpectedResult.success());

        GetResponse getResponse = api.userSteps.adExtensionsSteps().getAdExtensions(
                new GetRequestMap()
                        .withFieldNames(AdExtensionFieldEnum.ID, AdExtensionFieldEnum.ASSOCIATED)
                        .withSelectionCriteria(
                                new AdExtensionsSelectionCriteriaMap()
                                        .withIds(id1)
                        )
        );
        assertThat("вернулось правиное уточнение", getResponse.getAdExtensions(),
                beanDiffer(Arrays.asList(
                        new AdExtensionGetItemMap().withId(id1).withAssociated(YesNoEnum.NO).getBean()
                )));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("2262")
    public void getAdExtensionLinkedToTwoAds() {
        api.userSteps.adsSteps().shouldGetResultOnAdd(new AddRequestMap()
                        .withAds(new AdAddItemMap()
                                        .withTextAd(new TextAdAddMap().defaultTextAd().withAdExtensionIds(id1))
                                        .withAdGroupId(adGroupId),
                                new AdAddItemMap()
                                        .withTextAd(new TextAdAddMap().defaultTextAd().withAdExtensionIds(id1))
                                        .withAdGroupId(adGroupId)),
                ExpectedResult.success(), ExpectedResult.success());

        GetResponse getResponse = api.userSteps.adExtensionsSteps().getAdExtensions(
                new GetRequestMap()
                        .withFieldNames(AdExtensionFieldEnum.ID, AdExtensionFieldEnum.ASSOCIATED)
                        .withSelectionCriteria(
                                new AdExtensionsSelectionCriteriaMap()
                                        .withIds(id1)
                        )
        );
        assertThat("вернулось правиное уточнение", getResponse.getAdExtensions(),
                beanDiffer(Arrays.asList(
                        new AdExtensionGetItemMap().withId(id1).withAssociated(YesNoEnum.YES).getBean()
                )));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("2258")
    public void getAdExtensionLinkedToOneAdAndUnlinkedFromOtherAd() {
        Long adId = api.userSteps.adsSteps().shouldGetResultOnAdd(new AddRequestMap()
                        .withAds(new AdAddItemMap()
                                        .withTextAd(new TextAdAddMap().defaultTextAd().withAdExtensionIds(id1))
                                        .withAdGroupId(adGroupId),
                                new AdAddItemMap()
                                        .withTextAd(new TextAdAddMap().defaultTextAd().withAdExtensionIds(id1))
                                        .withAdGroupId(adGroupId)),
                ExpectedResult.success(), ExpectedResult.success()).getAddResults().get(0).getId();

        api.userSteps.adsSteps().shouldGetResultOnUpdate(new UpdateRequestMap().withAds(new AdUpdateItemMap()
                .withId(adId)
                .withTextAd(new TextAdUpdateMap()
                        .withCalloutSetting(new AdExtensionSettingMap()
                                .withAdExtensions(new AdExtensionSettingItemMap()
                                        .withOperation(OperationEnum.REMOVE)
                                        .withAdExtensionId(id1))))), ExpectedResult.success());

        GetResponse getResponse = api.userSteps.adExtensionsSteps().getAdExtensions(
                new GetRequestMap()
                        .withFieldNames(AdExtensionFieldEnum.ID, AdExtensionFieldEnum.ASSOCIATED)
                        .withSelectionCriteria(
                                new AdExtensionsSelectionCriteriaMap()
                                        .withIds(id1)
                        )
        );
        assertThat("вернулось правиное уточнение", getResponse.getAdExtensions(),
                beanDiffer(Arrays.asList(
                        new AdExtensionGetItemMap().withId(id1).withAssociated(YesNoEnum.YES).getBean()
                )));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("2263")
    public void getLinkedAndNotLinkedAdExtensions() {
        Long id2 = api.userSteps.adExtensionsSteps().addCalloutWithText(RandomStringUtils.randomAlphabetic(8));

        api.userSteps.adsSteps().shouldGetResultOnAdd(new AddRequestMap()
                        .withAds(new AdAddItemMap()
                                .withTextAd(new TextAdAddMap().defaultTextAd().withAdExtensionIds(id1))
                                .withAdGroupId(adGroupId)),
                ExpectedResult.success());

        GetResponse getResponse = api.userSteps.adExtensionsSteps().getAdExtensions(
                new GetRequestMap()
                        .withFieldNames(AdExtensionFieldEnum.ID, AdExtensionFieldEnum.ASSOCIATED)
                        .withSelectionCriteria(
                                new AdExtensionsSelectionCriteriaMap()
                                        .withIds(id1, id2)
                        )
        );
        assertThat("вернулось правиное уточнение", getResponse.getAdExtensions(),
                beanDiffer(Arrays.asList(
                        new AdExtensionGetItemMap().withId(id1).withAssociated(YesNoEnum.YES).getBean(),
                        new AdExtensionGetItemMap().withId(id2).withAssociated(YesNoEnum.NO).getBean()
                )));
    }
}
