package ru.yandex.autotests.direct.api.adextensions.get;

import com.yandex.direct.api.v5.adextensions.AdExtensionFieldEnum;
import com.yandex.direct.api.v5.adextensions.GetResponse;
import com.yandex.direct.api.v5.adextensiontypes.AdExtensionStateSelectionEnum;
import com.yandex.direct.api.v5.general.StateEnum;
import org.apache.commons.lang.RandomStringUtils;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.adextensions.AdExtensionsFeatures;
import ru.yandex.autotests.direct.api.adextensions.AdExtensionsLogins;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.api5.adextensions.AdExtensionGetItemMap;
import ru.yandex.autotests.directapi.model.api5.adextensions.AdExtensionsSelectionCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.adextensions.GetRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;
import ru.yandex.qatools.allure.annotations.TestCaseId;

import java.util.Arrays;

import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.beandiffer2.BeanDifferMatcher.beanDiffer;

/**
 * Created by proxeter on 28.02.16.
 * <p>
 * https://st.yandex-team.ru/TESTIRT-8603
 */
@Aqua.Test
@Description("Проверка получения удаленного текстового дополнения")
@Issue("https://st.yandex-team.ru/DIRECT-50724")
@Features(AdExtensionsFeatures.GET)
@Tag(TagDictionary.TRUNK)
public class GetDeletedAdExtensionTest {

    private static final String LOGIN = AdExtensionsLogins.AD_EXTENSIONS_CLIENT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);

    @Rule
    public Trashman trashman = new Trashman(api);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    private static Long id;

    @BeforeClass
    public static void beforeClass() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);
        id = api.userSteps.adExtensionsSteps().addCalloutWithText(RandomStringUtils.randomAlphabetic(8));
        api.userSteps.adExtensionsSteps().adExtensionsDelete(id);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("2265")
    public void getDeletedAdExtensionById() {
        GetResponse getResponse = api.userSteps.adExtensionsSteps().getAdExtensions(
                new GetRequestMap()
                        .withFieldNames(AdExtensionFieldEnum.ID, AdExtensionFieldEnum.STATE)
                        .withSelectionCriteria(
                                new AdExtensionsSelectionCriteriaMap().withIds(id)
                        )
        );
        assertThat("вернулось правиное уточнение", getResponse.getAdExtensions(),
                beanDiffer(Arrays.asList(
                        new AdExtensionGetItemMap().withId(id).withState(StateEnum.DELETED).getBean()
                )));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("2264")
    public void getDeletedAdExtensionByIdAndState() {
        GetResponse getResponse = api.userSteps.adExtensionsSteps().getAdExtensions(
                new GetRequestMap()
                        .withFieldNames(AdExtensionFieldEnum.ID, AdExtensionFieldEnum.STATE)
                        .withSelectionCriteria(
                                new AdExtensionsSelectionCriteriaMap()
                                        .withIds(id)
                                        .withStates(AdExtensionStateSelectionEnum.DELETED)
                        )
        );
        assertThat("вернулось правиное уточнение", getResponse.getAdExtensions(),
                beanDiffer(Arrays.asList(
                        new AdExtensionGetItemMap().withId(id).withState(StateEnum.DELETED).getBean()
                )));
    }
}
