package ru.yandex.autotests.direct.api.adextensions.get;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

import com.yandex.direct.api.v5.adextensions.AdExtensionFieldEnum;
import com.yandex.direct.api.v5.adextensions.AdExtensionGetItem;
import com.yandex.direct.api.v5.adextensions.AddResponse;
import com.yandex.direct.api.v5.adextensions.CalloutFieldEnum;
import com.yandex.direct.api.v5.adextensions.GetResponse;
import com.yandex.direct.api.v5.adextensiontypes.AdExtensionTypeEnum;
import com.yandex.direct.api.v5.general.ActionResult;
import com.yandex.direct.api.v5.general.StateEnum;
import com.yandex.direct.api.v5.general.StatusEnum;
import com.yandex.direct.api.v5.general.YesNoEnum;
import org.apache.commons.lang.RandomStringUtils;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.adextensions.AdExtensionsFeatures;
import ru.yandex.autotests.direct.api.adextensions.AdExtensionsLogins;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5Error;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetailsJava;
import ru.yandex.autotests.directapi.model.api5.adextensions.AdExtensionAddItemMap;
import ru.yandex.autotests.directapi.model.api5.adextensions.AdExtensionGetItemMap;
import ru.yandex.autotests.directapi.model.api5.adextensions.AdExtensionsSelectionCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.adextensions.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.adextensions.GetRequestMap;
import ru.yandex.autotests.directapi.model.api5.adextensiontypes.CalloutMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.containsInAnyOrder;
import static ru.yandex.autotests.directapi.apiclient.errors.Path.path;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.beandiffer2.BeanDifferMatcher.beanDiffer;

/**
 * Created by proxeter on 09.03.16.
 * <p>
 * https://st.yandex-team.ru/TESTIRT-8603
 */
@Aqua.Test
@Description("Проверка получения двух текстовых дополнений")
@Issue("https://st.yandex-team.ru/DIRECT-50724")
@Features(AdExtensionsFeatures.GET)
@Tag(TagDictionary.TRUNK)
public class GetTwoAdExtensionTest {

    private static final String LOGIN = AdExtensionsLogins.AD_EXTENSIONS_CLIENT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);

    @Rule
    public Trashman trashman = new Trashman(api);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    private List<Long> expectedIds;

    private String calloutText1 = RandomStringUtils.random(8, true, false);
    private String calloutText2 = RandomStringUtils.random(8, true, false);

    @Before
    public void before() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);

        AddResponse addResponse = api.userSteps.adExtensionsSteps().shouldGetResultOnAdExtensionsAdd(
                new AddRequestMap().withAdExtensions(
                        new AdExtensionAddItemMap()
                                .withCallout(
                                        new CalloutMap().withCalloutText(calloutText1)
                                ),
                        new AdExtensionAddItemMap()
                                .withCallout(
                                        new CalloutMap().withCalloutText(calloutText2)
                                )
                ),
                ExpectedResult.success(),
                ExpectedResult.success()
        );

        expectedIds = addResponse.getAddResults().stream().map(ActionResult::getId).collect(Collectors.toList());
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("2266")
    public void getTwoAdExtensions() {
        GetResponse getResponse = api.userSteps.adExtensionsSteps().getAdExtensions(
                new GetRequestMap()
                        .withFieldNames(AdExtensionFieldEnum.values())
                        .withSelectionCriteria(
                                new AdExtensionsSelectionCriteriaMap()
                                        .withIds(expectedIds.stream().toArray(Long[]::new))
                        )
        );

        List<Long> actualIds =
                getResponse.getAdExtensions().stream().map(AdExtensionGetItem::getId).collect(Collectors.toList());

        assertThat(
                "найдены правильные текстовые дополнения",
                actualIds,
                containsInAnyOrder(expectedIds.stream().toArray())
        );
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("2267")
    public void getTwoEquivalentAdExtensions() {
        Long id = expectedIds.get(0);

        GetResponse getResponse = api.userSteps.adExtensionsSteps().getAdExtensions(
                new GetRequestMap()
                        .withFieldNames(AdExtensionFieldEnum.values())
                        .withSelectionCriteria(
                                new AdExtensionsSelectionCriteriaMap()
                                        .withIds(id, id)
                        )
        );

        List<Long> actualIds =
                getResponse.getAdExtensions().stream().map(AdExtensionGetItem::getId).collect(Collectors.toList());

        assertThat("найдены правильные текстовые дополнения", actualIds, beanDiffer(Arrays.asList(id)));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("2268")
    public void getMaximumAdExtensions() {
        Long[] ids = new Long[AdExtensionsSelectionCriteriaMap.IDS_MAXIMUM];
        Arrays.fill(ids, expectedIds.get(0));

        GetResponse getResponse = api.userSteps.adExtensionsSteps().getAdExtensions(
                new GetRequestMap()
                        .withFieldNames(AdExtensionFieldEnum.values())
                        .withCalloutFieldNames(CalloutFieldEnum.CALLOUT_TEXT)
                        .withSelectionCriteria(
                                new AdExtensionsSelectionCriteriaMap()
                                        .withIds(ids)
                        )
        );

        AdExtensionGetItem expectedAdExtension =
                (AdExtensionGetItem) new AdExtensionGetItemMap()
                        .withId(expectedIds.get(0))
                        .withStatus(StatusEnum.MODERATION)
                        .withState(StateEnum.ON)
                        .withAssociated(YesNoEnum.NO)
                        .withStatusClarification("")
                        .withType(AdExtensionTypeEnum.CALLOUT)
                        .withCallout(new CalloutMap().withCalloutText(calloutText1))
                        .getBean();

        assertThat(
                "вернулось одно текстовое дополнение",
                getResponse.getAdExtensions(),
                beanDiffer(Arrays.asList(expectedAdExtension)
                )
        );
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("2269")
    public void getMoreThanMaximumAdExtensions() {
        Long[] ids = new Long[AdExtensionsSelectionCriteriaMap.IDS_MAXIMUM + 1];
        Arrays.fill(ids, expectedIds.get(0));

        api.userSteps.adExtensionsSteps().expectErrorOnGet(
                new GetRequestMap()
                        .withFieldNames(AdExtensionFieldEnum.values())
                        .withCalloutFieldNames(CalloutFieldEnum.CALLOUT_TEXT)
                        .withSelectionCriteria(
                                new AdExtensionsSelectionCriteriaMap()
                                        .withIds(ids)
                        ).getBean(),
                new Api5Error(
                        4001,
                        Api5ErrorDetailsJava.MAX_IDS_IN_SELECTION,
                        path(GetRequestMap.SELECTION_CRITERIA, AdExtensionsSelectionCriteriaMap.IDS)
                )
        );
    }

}
