package ru.yandex.autotests.direct.api.adextensions.get;

import java.sql.Timestamp;
import java.util.Arrays;

import com.yandex.direct.api.v5.adextensions.AdExtensionFieldEnum;
import com.yandex.direct.api.v5.adextensions.GetResponse;
import com.yandex.direct.api.v5.adextensiontypes.AdExtensionStateSelectionEnum;
import com.yandex.direct.api.v5.adextensiontypes.AdExtensionTypeEnum;
import com.yandex.direct.api.v5.general.ExtensionStatusSelectionEnum;
import org.apache.commons.lang.RandomStringUtils;
import org.joda.time.DateTime;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.adextensions.AdExtensionsFeatures;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.AdditionsItemCalloutsStatusmoderate;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.AdditionsItemCalloutsRecord;
import ru.yandex.autotests.direct.db.steps.DirectJooqDbSteps;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.common.api45mng.APIPort_PortType;
import ru.yandex.autotests.directapi.common.api45mng.CreateNewSubclientResponse;
import ru.yandex.autotests.directapi.model.Logins;
import ru.yandex.autotests.directapi.model.api5.adextensions.AdExtensionGetItemMap;
import ru.yandex.autotests.directapi.model.api5.adextensions.AdExtensionsSelectionCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.adextensions.GetRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.beandiffer.BeanDifferMatcher.beanDiffer;

/**
 * Created by pavryabov on 24.03.16.
 * https://st.yandex-team.ru/TESTIRT-8603
 */
@Aqua.Test
@Description("Проверка фильтрации без Ids")
@Issue("https://st.yandex-team.ru/DIRECT-50724")
@Features(AdExtensionsFeatures.GET)
public class GetWithoutIdsTest {

    private static String agency = Logins.AGENCY_ANOTHER;
    private static final String PATTERN_API = "yyyy-MM-dd'T'HH:mm:ss'Z'";

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104);
    private static DirectJooqDbSteps jooqDbSteps;

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private static String login;
    private static Long draftId;
    private static Long moderationId;
    private static Long deletedId;
    private static DateTime dateTime;

    @BeforeClass
    public static void prepareData() {
        dateTime = DateTime.now();
        api.as(agency).wsdl(APIPort_PortType.class);
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(agency);
        api.userSteps.clientFakeSteps().setAgencyCreateSubClients(agency, "Yes");
        CreateNewSubclientResponse createNewSubclientResponse =
                api.userSteps.clientSteps().createNewAgencySubClient("at-adextensionstest-", agency);
        login = createNewSubclientResponse.getLogin();

        draftId = api.userSteps.adExtensionsSteps().addCalloutWithText(RandomStringUtils.randomAlphabetic(8), login);
        moderationId =
                api.userSteps.adExtensionsSteps().addCalloutWithText(RandomStringUtils.randomAlphabetic(8), login);

        jooqDbSteps = api.userSteps.getDirectJooqDbSteps().useShardForLogin(login);
        AdditionsItemCalloutsRecord additionsItemCallouts = jooqDbSteps.bannerAdditionsSteps().getCallout(draftId);
        additionsItemCallouts.setStatusmoderate(AdditionsItemCalloutsStatusmoderate.New);
        additionsItemCallouts.setLastChange(new Timestamp(dateTime.minusMinutes(3).getMillis()));
        jooqDbSteps.bannerAdditionsSteps().updateAdditionsItemCallouts(additionsItemCallouts);

        additionsItemCallouts = jooqDbSteps.bannerAdditionsSteps().getCallout(moderationId);
        additionsItemCallouts.setStatusmoderate(AdditionsItemCalloutsStatusmoderate.Ready);
        additionsItemCallouts.setLastChange(new Timestamp(dateTime.minusMinutes(1).getMillis()));
        jooqDbSteps.bannerAdditionsSteps().updateAdditionsItemCallouts(additionsItemCallouts);

        dateTime = dateTime.minusHours(3);//Переходим на UTC

        deletedId = api.userSteps.adExtensionsSteps().addCalloutWithText(RandomStringUtils.randomAlphabetic(8), login);
        api.userSteps.adExtensionsSteps().adExtensionsDelete(login, deletedId);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("2270")
    public void getWithEmprtySelectionCriteria() {
        GetResponse getResponse = api.userSteps.adExtensionsSteps().getAdExtensions(
                new GetRequestMap()
                        .withFieldNames(AdExtensionFieldEnum.ID)
                        .withSelectionCriteria(new AdExtensionsSelectionCriteriaMap()),
                login
        );
        assertThat("вернулся правильный ответ", getResponse.getAdExtensions(), beanDiffer(
                Arrays.asList(
                        new AdExtensionGetItemMap().withId(draftId).getBean(),
                        new AdExtensionGetItemMap().withId(moderationId).getBean())));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("2271")
    public void getStatusesWithoutIds() {
        GetResponse getResponse = api.userSteps.adExtensionsSteps().getAdExtensions(
                new GetRequestMap()
                        .withFieldNames(AdExtensionFieldEnum.ID)
                        .withSelectionCriteria(new AdExtensionsSelectionCriteriaMap()
                                .withStatuses(ExtensionStatusSelectionEnum.DRAFT)),
                login
        );
        assertThat("вернулся правильный ответ", getResponse.getAdExtensions(), beanDiffer(
                Arrays.asList(new AdExtensionGetItemMap().withId(draftId).getBean())));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("2272")
    public void getStatesWithoutIds() {
        GetResponse getResponse = api.userSteps.adExtensionsSteps().getAdExtensions(
                new GetRequestMap()
                        .withFieldNames(AdExtensionFieldEnum.ID)
                        .withSelectionCriteria(new AdExtensionsSelectionCriteriaMap()
                                .withStates(AdExtensionStateSelectionEnum.ON)),
                login
        );
        assertThat("вернулся правильный ответ", getResponse.getAdExtensions(), beanDiffer(
                Arrays.asList(
                        new AdExtensionGetItemMap().withId(draftId).getBean(),
                        new AdExtensionGetItemMap().withId(moderationId).getBean()
                )));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("2273")
    public void getStateDeletedWithoutIds() {
        //DIRECT-52790
        GetResponse getResponse = api.userSteps.adExtensionsSteps().getAdExtensions(
                new GetRequestMap()
                        .withFieldNames(AdExtensionFieldEnum.ID)
                        .withSelectionCriteria(new AdExtensionsSelectionCriteriaMap()
                                .withStates(AdExtensionStateSelectionEnum.DELETED)),
                login
        );
        assertThat("вернулся правильный ответ", getResponse.getAdExtensions(), beanDiffer(
                Arrays.asList(new AdExtensionGetItemMap().withId(deletedId).getBean())));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("2274")
    public void getTypesWithoutIds() {
        GetResponse getResponse = api.userSteps.adExtensionsSteps().getAdExtensions(
                new GetRequestMap()
                        .withFieldNames(AdExtensionFieldEnum.ID)
                        .withSelectionCriteria(new AdExtensionsSelectionCriteriaMap()
                                .withTypes(AdExtensionTypeEnum.CALLOUT)),
                login
        );
        assertThat("вернулся правильный ответ", getResponse.getAdExtensions(), beanDiffer(
                Arrays.asList(
                        new AdExtensionGetItemMap().withId(draftId).getBean(),
                        new AdExtensionGetItemMap().withId(moderationId).getBean())));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("2275")
    public void getWithOnlyModifiedSince() {
        //DIRECT-52827
        GetResponse getResponse = api.userSteps.adExtensionsSteps().getAdExtensions(
                new GetRequestMap()
                        .withFieldNames(AdExtensionFieldEnum.ID)
                        .withSelectionCriteria(new AdExtensionsSelectionCriteriaMap()
                                .withModifiedSince(dateTime.minusMinutes(2).toString(PATTERN_API))),
                login
        );
        assertThat("вернулся правильный ответ", getResponse.getAdExtensions(), beanDiffer(
                Arrays.asList(
                        new AdExtensionGetItemMap().withId(moderationId).getBean()
                )));
    }
}
