package ru.yandex.autotests.direct.api.adextensions.get;

import com.yandex.direct.api.v5.adextensions.AdExtensionFieldEnum;
import com.yandex.direct.api.v5.adextensions.GetResponse;
import org.apache.commons.lang.RandomStringUtils;
import org.hamcrest.Matcher;
import org.joda.time.DateTime;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.adextensions.AdExtensionsFeatures;
import ru.yandex.autotests.direct.api.adextensions.AdExtensionsLogins;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.AdditionsItemCalloutsStatusmoderate;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.AdditionsItemCalloutsRecord;
import ru.yandex.autotests.direct.db.steps.DirectJooqDbSteps;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.api5.adextensions.AdExtensionGetItemMap;
import ru.yandex.autotests.directapi.model.api5.adextensions.AdExtensionsSelectionCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.adextensions.GetRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Collection;

import static org.hamcrest.Matchers.hasSize;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.beandiffer.BeanDifferMatcher.beanDiffer;

/**
 * Created by pavryabov on 04.04.16.
 * https://st.yandex-team.ru/TESTIRT-8935
 */
@Aqua.Test
@Description("Проверка фильтрации при использовании нескольких критериев (Ids + ModifiedSince)")
@Issue("https://st.yandex-team.ru/DIRECT-51268")
@Features(AdExtensionsFeatures.GET)
@RunWith(Parameterized.class)
@Tag(TagDictionary.TRUNK)
public class IdsWithModifiedSinceFilterTest {

    private static String CLIENT = AdExtensionsLogins.AD_EXTENSIONS_CLIENT;

    private static final String PATTERN_API = "yyyy-MM-dd'T'HH:mm:ss'Z'";

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).as(CLIENT);
    private static DirectJooqDbSteps jooqDbSteps;

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private static Long id1;
    private static Long id2;
    private static DateTime dateTime = DateTime.now();
    private static DateTime dateTimeUTC = dateTime.minusHours(3);

    @Parameterized.Parameter(0)
    public String description;

    @Parameterized.Parameter(1)
    public DateTime modifiedSince;

    @Parameterized.Parameter(2)
    public Matcher matcher;

    @Parameterized.Parameters(name = "{0}")
    public static Collection testData() {
        id1 = api.userSteps.adExtensionsSteps().addCalloutWithText(RandomStringUtils.randomAlphabetic(8));
        id2 = api.userSteps.adExtensionsSteps().addCalloutWithText(RandomStringUtils.randomAlphabetic(8));
        Object[][] data = new Object[][]{
                {"ModifiedSince до модификации обоих уточнений", dateTimeUTC.minusMinutes(3),
                        beanDiffer(
                                Arrays.asList(
                                        new AdExtensionGetItemMap().withId(id1).getBean(),
                                        new AdExtensionGetItemMap().withId(id2).getBean()
                                ))},
                {"ModifiedSince совпадает с модификацией одного уточнения и раньше другого",
                        dateTimeUTC.minusMinutes(2),
                        beanDiffer(
                                Arrays.asList(
                                        new AdExtensionGetItemMap().withId(id1).getBean(),
                                        new AdExtensionGetItemMap().withId(id2).getBean()
                                ))},
                {"ModifiedSince после модификации одного уточнения и до другого",
                        dateTimeUTC.minusMinutes(1).minusSeconds(30),
                        beanDiffer(
                                Arrays.asList(
                                        new AdExtensionGetItemMap().withId(id2).getBean()
                                ))},
                {"ModifiedSince после модификации одного уточнения и одновременно с другим",
                        dateTimeUTC.minusMinutes(1),
                        beanDiffer(
                                Arrays.asList(
                                        new AdExtensionGetItemMap().withId(id2).getBean()
                                ))},
                {"ModifiedSince после модификации обоих уточнений", dateTimeUTC, hasSize(0)},
                {"ModifiedSince в будущем", dateTimeUTC.plusDays(1), hasSize(0)},
        };
        return Arrays.asList(data);
    }

    @BeforeClass
    public static void initTest() {
        jooqDbSteps = api.userSteps.getDirectJooqDbSteps().useShardForLogin(CLIENT);
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(CLIENT);

        AdditionsItemCalloutsRecord additionsItemCallouts = jooqDbSteps.bannerAdditionsSteps().getCallout(id1);
        additionsItemCallouts.setStatusmoderate(AdditionsItemCalloutsStatusmoderate.New);
        additionsItemCallouts.setLastChange(new Timestamp(dateTime.minusMinutes(2).getMillis()));
        jooqDbSteps.bannerAdditionsSteps().updateAdditionsItemCallouts(additionsItemCallouts);

        additionsItemCallouts = jooqDbSteps.bannerAdditionsSteps().getCallout(id2);
        additionsItemCallouts.setStatusmoderate(AdditionsItemCalloutsStatusmoderate.Ready);
        additionsItemCallouts.setLastChange(new Timestamp(dateTime.minusMinutes(1).getMillis()));
        jooqDbSteps.bannerAdditionsSteps().updateAdditionsItemCallouts(additionsItemCallouts);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("2276")
    public void getWithModifiedSinceBeforeBothCallouts() {
        GetResponse getResponse = api.userSteps.adExtensionsSteps().getAdExtensions(
                new GetRequestMap()
                        .withFieldNames(AdExtensionFieldEnum.ID)
                        .withSelectionCriteria(new AdExtensionsSelectionCriteriaMap()
                                .withIds(id1, id2)
                                .withModifiedSince(modifiedSince.toString(PATTERN_API)))
        );
        assertThat("вернулся правильный ответ", getResponse.getAdExtensions(), matcher);
    }
}
