package ru.yandex.autotests.direct.api.adextensions.get;

import com.yandex.direct.api.v5.adextensions.AdExtensionFieldEnum;
import com.yandex.direct.api.v5.adextensions.GetResponse;
import com.yandex.direct.api.v5.adextensiontypes.AdExtensionStateSelectionEnum;
import org.apache.commons.lang.RandomStringUtils;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.adextensions.AdExtensionsFeatures;
import ru.yandex.autotests.direct.api.adextensions.AdExtensionsLogins;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.api5.adextensions.AdExtensionGetItemMap;
import ru.yandex.autotests.directapi.model.api5.adextensions.AdExtensionsSelectionCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.adextensions.GetRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;
import ru.yandex.qatools.allure.annotations.TestCaseId;

import java.util.Arrays;

import static org.hamcrest.Matchers.hasSize;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.beandiffer.BeanDifferMatcher.beanDiffer;

/**
 * Created by pavryabov on 06.04.16.
 * https://st.yandex-team.ru/TESTIRT-8935
 */
@Aqua.Test
@Description("Проверка фильтрации при использовании нескольких критериев (Ids + States)")
@Issue("https://st.yandex-team.ru/DIRECT-52798")
@Features(AdExtensionsFeatures.GET)
public class IdsWithStatesFilterTest {

    private static String CLIENT = AdExtensionsLogins.AD_EXTENSIONS_CLIENT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).as(CLIENT);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    static Long onId;
    static Long deletedId;

    @BeforeClass
    public static void initTest() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(CLIENT);
        onId = api.userSteps.adExtensionsSteps().addCalloutWithText(RandomStringUtils.randomAlphabetic(8));
        deletedId = api.userSteps.adExtensionsSteps().addCalloutWithText(RandomStringUtils.randomAlphabetic(8));
        api.userSteps.adExtensionsSteps().adExtensionsDelete(deletedId);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("2277")
    public void getAdExtensionAndOtherState() {
        GetResponse getResponse = api.userSteps.adExtensionsSteps().getAdExtensions(new GetRequestMap()
                .withSelectionCriteria(new AdExtensionsSelectionCriteriaMap()
                        .withIds(onId)
                        .withStates(AdExtensionStateSelectionEnum.DELETED))
                .withFieldNames(AdExtensionFieldEnum.ID));
        assertThat("не вернулось ни одного уточнения", getResponse.getAdExtensions(), hasSize(0));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("2278")
    public void getAdExtensionAndTwoStates() {
        GetResponse getResponse = api.userSteps.adExtensionsSteps().getAdExtensions(
                new GetRequestMap()
                        .withSelectionCriteria(new AdExtensionsSelectionCriteriaMap()
                                .withIds(onId)
                                .withStates(AdExtensionStateSelectionEnum.ON, AdExtensionStateSelectionEnum.DELETED))
                        .withFieldNames(AdExtensionFieldEnum.ID));
        assertThat("вернулся правильный ответ", getResponse.getAdExtensions(), beanDiffer(
                Arrays.asList(new AdExtensionGetItemMap().withId(onId).getBean())));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("2279")
    public void getTwoAdExtensionsAndState() {
        GetResponse getResponse = api.userSteps.adExtensionsSteps().getAdExtensions(
                new GetRequestMap()
                        .withSelectionCriteria(new AdExtensionsSelectionCriteriaMap()
                                .withIds(onId, deletedId)
                                .withStates(AdExtensionStateSelectionEnum.ON))
                        .withFieldNames(AdExtensionFieldEnum.ID));
        assertThat("вернулся правильный ответ", getResponse.getAdExtensions(), beanDiffer(
                Arrays.asList(new AdExtensionGetItemMap().withId(onId).getBean())));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("2280")
    public void getTwoAdExtensionsAndTwoStates() {
        GetResponse getResponse = api.userSteps.adExtensionsSteps().getAdExtensions(
                new GetRequestMap()
                        .withSelectionCriteria(new AdExtensionsSelectionCriteriaMap()
                                .withIds(onId, deletedId)
                                .withStates(AdExtensionStateSelectionEnum.ON, AdExtensionStateSelectionEnum.DELETED))
                        .withFieldNames(AdExtensionFieldEnum.ID));
        assertThat("вернулся правильный ответ", getResponse.getAdExtensions(), beanDiffer(
                Arrays.asList(
                        new AdExtensionGetItemMap().withId(onId).getBean(),
                        new AdExtensionGetItemMap().withId(deletedId).getBean())));
    }
}
