package ru.yandex.autotests.direct.api.adextensions.get;

import com.yandex.direct.api.v5.adextensions.AdExtensionFieldEnum;
import com.yandex.direct.api.v5.adextensions.GetResponse;
import com.yandex.direct.api.v5.general.ExtensionStatusSelectionEnum;
import org.apache.commons.lang.RandomStringUtils;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.adextensions.AdExtensionsFeatures;
import ru.yandex.autotests.direct.api.adextensions.AdExtensionsLogins;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.AdditionsItemCalloutsStatusmoderate;
import ru.yandex.autotests.direct.db.steps.DirectJooqDbSteps;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.api5.adextensions.AdExtensionGetItemMap;
import ru.yandex.autotests.directapi.model.api5.adextensions.AdExtensionsSelectionCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.adextensions.GetRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import java.util.Arrays;

import static org.hamcrest.Matchers.hasSize;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.beandiffer.BeanDifferMatcher.beanDiffer;

/**
 * Created by pavryabov on 24.03.16.
 * https://st.yandex-team.ru/TESTIRT-8603
 */
@Aqua.Test
@Description("Проверка фильтрации при использовании нескольких критериев (Ids + Statuses)")
@Issue("https://st.yandex-team.ru/DIRECT-50724")
@Features(AdExtensionsFeatures.GET)
public class IdsWithStatusesFilterTest {

    private static String CLIENT = AdExtensionsLogins.AD_EXTENSIONS_CLIENT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).as(CLIENT);
    private static DirectJooqDbSteps jooqDbSteps;

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    static Long draftId;
    static Long moderationId;

    @BeforeClass
    public static void initTest() {
        jooqDbSteps = api.userSteps.getDirectJooqDbSteps().useShardForLogin(CLIENT);
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(CLIENT);
        draftId = api.userSteps.adExtensionsSteps().addCalloutWithText(RandomStringUtils.randomAlphabetic(8));
        moderationId = api.userSteps.adExtensionsSteps().addCalloutWithText(RandomStringUtils.randomAlphabetic(8));
        jooqDbSteps.bannerAdditionsSteps().setAdditionsItemCalloutsStatusModerated(draftId, AdditionsItemCalloutsStatusmoderate.New);
        jooqDbSteps.bannerAdditionsSteps().setAdditionsItemCalloutsStatusModerated(moderationId, AdditionsItemCalloutsStatusmoderate.Ready);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("2281")
    public void getAdExtensionAndOtherStatus() {
        GetResponse getResponse = api.userSteps.adExtensionsSteps().getAdExtensions(new GetRequestMap()
                .withSelectionCriteria(new AdExtensionsSelectionCriteriaMap()
                        .withIds(draftId)
                        .withStatuses(ExtensionStatusSelectionEnum.MODERATION))
                .withFieldNames(AdExtensionFieldEnum.ID));
        assertThat("не вернулось ни одного уточнения", getResponse.getAdExtensions(), hasSize(0));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("2282")
    public void getAdExtensionAndTwoStatuses() {
        GetResponse getResponse = api.userSteps.adExtensionsSteps().getAdExtensions(
                new GetRequestMap()
                        .withSelectionCriteria(new AdExtensionsSelectionCriteriaMap()
                                .withIds(draftId)
                                .withStatuses(ExtensionStatusSelectionEnum.DRAFT, ExtensionStatusSelectionEnum.MODERATION))
                        .withFieldNames(AdExtensionFieldEnum.ID));
        assertThat("вернулся правильный ответ", getResponse.getAdExtensions(), beanDiffer(
                Arrays.asList(new AdExtensionGetItemMap().withId(draftId).getBean())));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("2283")
    public void getTwoAdExtensionsAndStatus() {
        GetResponse getResponse = api.userSteps.adExtensionsSteps().getAdExtensions(
                new GetRequestMap()
                        .withSelectionCriteria(new AdExtensionsSelectionCriteriaMap()
                                .withIds(draftId, moderationId)
                                .withStatuses(ExtensionStatusSelectionEnum.DRAFT))
                        .withFieldNames(AdExtensionFieldEnum.ID));
        assertThat("вернулся правильный ответ", getResponse.getAdExtensions(), beanDiffer(
                Arrays.asList(new AdExtensionGetItemMap().withId(draftId).getBean())));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("2284")
    public void getTwoAdExtensionsAndTwoStatuses() {
        GetResponse getResponse = api.userSteps.adExtensionsSteps().getAdExtensions(
                new GetRequestMap()
                        .withSelectionCriteria(new AdExtensionsSelectionCriteriaMap()
                                .withIds(draftId, moderationId)
                                .withStatuses(ExtensionStatusSelectionEnum.DRAFT, ExtensionStatusSelectionEnum.MODERATION))
                        .withFieldNames(AdExtensionFieldEnum.ID));
        assertThat("вернулся правильный ответ", getResponse.getAdExtensions(), beanDiffer(
                Arrays.asList(
                        new AdExtensionGetItemMap().withId(draftId).getBean(),
                        new AdExtensionGetItemMap().withId(moderationId).getBean())));
    }
}
