package ru.yandex.autotests.direct.api.adextensions.get;

import com.yandex.direct.api.v5.adextensions.AdExtensionFieldEnum;
import com.yandex.direct.api.v5.adextensiontypes.AdExtensionTypeEnum;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.adextensions.AdExtensionsFeatures;
import ru.yandex.autotests.direct.api.adextensions.AdExtensionsLogins;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5Error;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetailsJava;
import ru.yandex.autotests.directapi.model.api5.adextensions.AdExtensionsSelectionCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.adextensions.GetRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.apache.commons.lang.StringUtils.uncapitalize;
import static ru.yandex.autotests.directapi.apiclient.errors.Path.path;

/**
 * Created by pavryabov on 24.03.16.
 * https://st.yandex-team.ru/TESTIRT-8603
 */
@Aqua.Test
@Description("Неправильные значения в полях, принимающих Enum'ы")
@Issue("https://st.yandex-team.ru/DIRECT-50724")
@Features(AdExtensionsFeatures.GET)
public class InvalidValuesInEnumsTest {

    private static final String LOGIN = AdExtensionsLogins.AD_EXTENSIONS_CLIENT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);

    @Rule
    public Trashman trashman = new Trashman(api);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("2286")
    public void invalidValueInFieldNames() {
        api.userSteps.adExtensionsSteps().expectErrorOnAdExtensionsGet(
                new GetRequestMap()
                        .withSelectionCriteria(new AdExtensionsSelectionCriteriaMap().withIds(123L))
                        .withFieldNames(uncapitalize(AdExtensionFieldEnum.STATUS.toString())),
                new Api5Error(8000, Api5ErrorDetailsJava.ELEMENT_OF_ARRAY_CONTAINS_INCORRECT_ENUMERATE_VALUE,
                        path(GetRequestMap.FIELD_NAMES),
                        Api5Error.enumAsParam(AdExtensionFieldEnum.class)
                )
        );
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("2287")
    public void invalidValueInSelectionCriteria() {
        api.userSteps.adExtensionsSteps().expectErrorOnAdExtensionsGet(
                new GetRequestMap()
                        .withSelectionCriteria(new AdExtensionsSelectionCriteriaMap()
                                .withIds(123L)
                                .withTypes(uncapitalize(AdExtensionTypeEnum.CALLOUT.toString())))
                        .withFieldNames(AdExtensionFieldEnum.STATUS.toString()),
                new Api5Error(8000, Api5ErrorDetailsJava.ELEMENT_OF_ARRAY_CONTAINS_INCORRECT_ENUMERATE_VALUE,
                        path(GetRequestMap.SELECTION_CRITERIA, AdExtensionsSelectionCriteriaMap.TYPES),
                        Api5Error.enumAsParam(AdExtensionTypeEnum.class)
                )
        );
    }
}
