package ru.yandex.autotests.direct.api.adextensions.get;

import java.util.Arrays;
import java.util.Collection;

import com.yandex.direct.api.v5.adextensions.AdExtensionFieldEnum;
import org.joda.time.DateTime;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.adextensions.AdExtensionsFeatures;
import ru.yandex.autotests.direct.api.adextensions.AdExtensionsLogins;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5Error;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetailsJava;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorMessage;
import ru.yandex.autotests.directapi.model.api5.adextensions.AdExtensionsSelectionCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.adextensions.GetRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static ru.yandex.autotests.directapi.apiclient.errors.Path.path;

/**
 * Created by pavryabov on 04.04.16.
 * https://st.yandex-team.ru/TESTIRT-8935
 */
@Aqua.Test
@Description("Проверка фильтрации при использовании нескольких критериев (Ids + ModifiedSince)")
@Issue("https://st.yandex-team.ru/DIRECT-51268")
@Features(AdExtensionsFeatures.GET)
@RunWith(Parameterized.class)
public class ModifiedSinceNegativeTest {

    private static final String CLIENT = AdExtensionsLogins.AD_EXTENSIONS_CLIENT;
    private static final String PATTERN_DB = "yyyy'-'MM'-'dd HH':'mm':'ss.S";

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).as(CLIENT);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Parameterized.Parameter(value = 0)
    public String modifiedSince;

    @Parameterized.Parameter(value = 1)
    public Api5Error expectedError;

    @Parameterized.Parameters(name = "ModifiedSince = {0}")
    public static Collection testData() {
        Object[][] data = new Object[][]{
                {"", new Api5Error(4000,
                        Api5ErrorDetailsJava.FIELD_MUST_CONTAIN_VALUE_IN_FORMAT,
                        path(AdExtensionsSelectionCriteriaMap.MODIFIED_SINCE))
                        .withMessageFromResource(Api5ErrorMessage.INVALID_REQUEST_PARAMETERS_JAVA)},
                {"0000-00-00T00:00:00Z", new Api5Error(4000,
                        Api5ErrorDetailsJava.CORRECT_DATE_MUST_BE_SPECIFIED,
                        path(AdExtensionsSelectionCriteriaMap.MODIFIED_SINCE))
                        .withMessageFromResource(Api5ErrorMessage.INVALID_REQUEST_PARAMETERS_JAVA)},
                {"abc", new Api5Error(4000,
                        Api5ErrorDetailsJava.FIELD_MUST_CONTAIN_VALUE_IN_FORMAT,
                        path(AdExtensionsSelectionCriteriaMap.MODIFIED_SINCE))
                        .withMessageFromResource(Api5ErrorMessage.INVALID_REQUEST_PARAMETERS_JAVA)},
                {DateTime.now().toString(PATTERN_DB), new Api5Error(4000,
                        Api5ErrorDetailsJava.FIELD_MUST_CONTAIN_VALUE_IN_FORMAT,
                        path(AdExtensionsSelectionCriteriaMap.MODIFIED_SINCE))
                        .withMessageFromResource(Api5ErrorMessage.INVALID_REQUEST_PARAMETERS_JAVA)}
        };
        return Arrays.asList(data);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("2288")
    public void invalidFormatOfModifiedSince() {
        api.userSteps.adExtensionsSteps().expectErrorOnAdExtensionsGet(
                new GetRequestMap()
                        .withSelectionCriteria(new AdExtensionsSelectionCriteriaMap()
                                .withModifiedSince(modifiedSince))
                        .withFieldNames(AdExtensionFieldEnum.STATUS),
                expectedError
        );
    }
}
