package ru.yandex.autotests.direct.api.adgroups.add;

import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.adgroups.AdGroupsFeatures;
import ru.yandex.autotests.direct.api.adgroups.AdGroupsLogins;
import ru.yandex.autotests.directapi.apiclient.config.ProtocolType;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5Error;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetailsJava;
import ru.yandex.autotests.directapi.model.api5.adgroups.AdGroupAddItemMap;
import ru.yandex.autotests.directapi.model.api5.adgroups.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static com.sun.xml.ws.util.StringUtils.capitalize;

/**
 * Created by pavryabov on 16.05.15.
 * https://st.yandex-team.ru/TESTIRT-5468
 */
@Aqua.Test
@Features(AdGroupsFeatures.ADD)
@Description("проверка SOAP")
public class AdGroupsAddSOAPTest {

    private static final String client = AdGroupsLogins.CLIENT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).protocol(ProtocolType.SOAP).as(client);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    static Long campaignId;

    @BeforeClass
    public static void initTest() {
        campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign(client);
    }

    @Before
    public void clearSpentUnits() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(client);
    }

    @Test
    public void successAddTest() {
        api.userSteps.adGroupsSteps().shouldGetResultOnAdd(
                new AddRequestMap().withAdGroups(
                        new AdGroupAddItemMap().defaultAdGroupAddItem(campaignId)
                ),
                ExpectedResult.success()
        );
    }

    @Test
    public void addWithoutName() {
        //DIRECT-33530
        api.userSteps.adGroupsSteps().expectErrorOnAdGroupsAdd(
                new AddRequestMap().withAdGroups(
                        new AdGroupAddItemMap()
                                .withCampaignId(campaignId)
                                .withRegionIds(0L)
                ),
                new Api5Error(8000, Api5ErrorDetailsJava.IN_ELEMENT_OF_ARRAY_MISSING_REQUIRED_FIELD,
                        capitalize(AddRequestMap.AD_GROUPS), capitalize(AdGroupAddItemMap.NAME)));
    }

    @Test
    public void addWithoutRegionIds() {
        //DIRECT-33530
        api.userSteps.adGroupsSteps().expectErrorOnAdGroupsAdd(
                new AddRequestMap().withAdGroups(
                        new AdGroupAddItemMap()
                                .withCampaignId(campaignId)
                                .withName(AdGroupAddItemMap.DEFAULT_NAME)
                ),
                new Api5Error(8000, Api5ErrorDetailsJava.IN_ELEMENT_OF_ARRAY_MISSING_REQUIRED_FIELD,
                        capitalize(AddRequestMap.AD_GROUPS), capitalize(AdGroupAddItemMap.REGION_IDS)));
    }

    @Test
    public void addWithoutTwoRequiredFields() {
        //DIRECT-33530
        api.userSteps.adGroupsSteps().expectErrorOnAdGroupsAdd(
                new AddRequestMap().withAdGroups(
                        new AdGroupAddItemMap()
                                .withCampaignId(campaignId)
                ),
                new Api5Error(8000, Api5ErrorDetailsJava.IN_ELEMENT_OF_ARRAY_MISSING_REQUIRED_FIELD,
                        capitalize(AddRequestMap.AD_GROUPS), capitalize(AdGroupAddItemMap.NAME)));
    }

    @Test
    public void addWithEmptyArrayOfNegativeKeywords() {
        //DIRECT-33530
        api.userSteps.adGroupsSteps().expectErrorOnAdGroupsAdd(
                new AddRequestMap().withAdGroups(
                        new AdGroupAddItemMap().defaultAdGroupAddItem(campaignId)
                                .withNegativeKeywords(new String[]{})
                ),
                (Api5Error) null);
                // TODO DIRECT-79270
//                new Api5Error(8000, Api5ErrorDetails.MISSING_REQUIRED_FIELD,
//                        capitalize(AdGroupBaseMap.NEGATIVE_KEYWORDS),
//                        capitalize(ArrayOfStringMap.ITEMS)));
    }

    @Test
    public void addWithEmptyRequest() {
        //DIRECT-33530
        api.userSteps.adGroupsSteps().expectErrorOnAdGroupsAdd(
                new AddRequestMap().withAdGroups((AdGroupAddItemMap[]) null),
                new Api5Error(8000,
                        Api5ErrorDetailsJava.MISSING_PARAMETER_VALUE,
                        capitalize(AddRequestMap.AD_GROUPS)));
    }
}
